/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services.internal;

import com.google.common.net.UrlEscapers;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiClientException;
import com.kms.katalon.ai.internal.model.UploadFileRequest;
import com.kms.katalon.ai.internal.model.UploadFileResponse;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadAttachmentCallable
implements Callable<UploadFileResponse> {
    private static final Integer MAX_TRY = 3;
    private static final String METADATA_FORMAT = "x-amz-meta-%s";
    private final Logger logger = LoggerFactory.getLogger(UploadAttachmentCallable.class);
    private StudioAssistChatAttachment attachment;
    private UploadFileRequest uploadFileRequest;
    private UploadFileResponse uploadFileResponse;
    private IHttpClient httpClient;
    private INetworkPreferences networkPreferences;

    public UploadAttachmentCallable(StudioAssistChatAttachment attachment, UploadFileRequest uploadFileRequest, UploadFileResponse uploadFileResponse, IHttpClient httpClient, INetworkPreferences networkPreferences) {
        this.attachment = attachment;
        this.uploadFileRequest = uploadFileRequest;
        this.uploadFileResponse = uploadFileResponse;
        this.httpClient = httpClient;
        this.networkPreferences = networkPreferences;
    }

    @Override
    public UploadFileResponse call() throws Exception {
        if (this.uploadFileResponse == null || StringUtils.isBlank((CharSequence)this.uploadFileResponse.getUploadSpec().getUrl())) {
            this.logger.error("There is no information from upload specification");
            throw new StudioAssistLlmApiClientException("There is no information from upload specification");
        }
        String url = this.uploadFileResponse.getUploadSpec().getUrl();
        HashMap<String, String> headers = new HashMap<String, String>();
        Optional.ofNullable(this.uploadFileRequest.getMetadata()).map(Map::entrySet).orElse(Collections.emptySet()).stream().forEach(entry -> {
            String key = String.format(METADATA_FORMAT, UrlEscapers.urlFragmentEscaper().escape((String)entry.getKey()));
            String value = (String)entry.getValue();
            headers.put(key, value);
        });
        String fileContent = this.attachment.getFileContent() == null ? "" : this.attachment.getFileContent();
        int count = 0;
        while (count < MAX_TRY) {
            try {
                HttpResponse response = this.httpClient.put(URI.create(url), (HttpEntity)new StringEntity(fileContent), this.buildHttpOptions(headers));
                if (200 == response.getStatusCode() && 201 == response.getStatusCode()) break;
                this.logger.warn("Upload attachment %s not success: %s".formatted(this.attachment.getFileId(), response.getBody()));
                break;
            }
            catch (Exception e) {
                this.logger.warn("Exception while upload file to S3", (Throwable)e);
                if (++count != MAX_TRY) continue;
                throw e;
            }
        }
        return this.uploadFileResponse;
    }

    private HttpOptions buildHttpOptions(Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        return httpOptions;
    }
}

