/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.BatchErrorList;
import com.azure.ai.openai.models.BatchRequestCounts;
import com.azure.ai.openai.models.BatchStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class Batch
implements JsonSerializable<Batch> {
    private final String id;
    private final String object = "batch";
    private String endpoint;
    private BatchErrorList errors;
    private final String inputFileId;
    private String completionWindow;
    private BatchStatus status;
    private String outputFileId;
    private String errorFileId;
    private Long createdAt;
    private Long inProgressAt;
    private Long expiresAt;
    private Long finalizingAt;
    private Long completedAt;
    private Long failedAt;
    private Long expiredAt;
    private Long cancellingAt;
    private Long cancelledAt;
    private BatchRequestCounts requestCounts;
    private Map<String, String> metadata;

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public BatchErrorList getErrors() {
        return this.errors;
    }

    public String getInputFileId() {
        return this.inputFileId;
    }

    public String getCompletionWindow() {
        return this.completionWindow;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public String getOutputFileId() {
        return this.outputFileId;
    }

    public String getErrorFileId() {
        return this.errorFileId;
    }

    public OffsetDateTime getCreatedAt() {
        if (this.createdAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getInProgressAt() {
        if (this.inProgressAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.inProgressAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getExpiresAt() {
        if (this.expiresAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiresAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getFinalizingAt() {
        if (this.finalizingAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.finalizingAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getCompletedAt() {
        if (this.completedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.completedAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getFailedAt() {
        if (this.failedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.failedAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getExpiredAt() {
        if (this.expiredAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiredAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getCancellingAt() {
        if (this.cancellingAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.cancellingAt), ZoneOffset.UTC);
    }

    public OffsetDateTime getCancelledAt() {
        if (this.cancelledAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.cancelledAt), ZoneOffset.UTC);
    }

    public BatchRequestCounts getRequestCounts() {
        return this.requestCounts;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeStringField("input_file_id", this.inputFileId);
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeJsonField("errors", (JsonSerializable)this.errors);
        jsonWriter.writeStringField("completion_window", this.completionWindow);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("output_file_id", this.outputFileId);
        jsonWriter.writeStringField("error_file_id", this.errorFileId);
        jsonWriter.writeNumberField("created_at", (Number)this.createdAt);
        jsonWriter.writeNumberField("in_progress_at", (Number)this.inProgressAt);
        jsonWriter.writeNumberField("expires_at", (Number)this.expiresAt);
        jsonWriter.writeNumberField("finalizing_at", (Number)this.finalizingAt);
        jsonWriter.writeNumberField("completed_at", (Number)this.completedAt);
        jsonWriter.writeNumberField("failed_at", (Number)this.failedAt);
        jsonWriter.writeNumberField("expired_at", (Number)this.expiredAt);
        jsonWriter.writeNumberField("cancelling_at", (Number)this.cancellingAt);
        jsonWriter.writeNumberField("cancelled_at", (Number)this.cancelledAt);
        jsonWriter.writeJsonField("request_counts", (JsonSerializable)this.requestCounts);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static Batch fromJson(JsonReader jsonReader) throws IOException {
        return (Batch)jsonReader.readObject(reader -> {
            String id = null;
            String inputFileId = null;
            String endpoint = null;
            BatchErrorList errors = null;
            String completionWindow = null;
            BatchStatus status = null;
            String outputFileId = null;
            String errorFileId = null;
            Long createdAt = null;
            Long inProgressAt = null;
            Long expiresAt = null;
            Long finalizingAt = null;
            Long completedAt = null;
            Long failedAt = null;
            Long expiredAt = null;
            Long cancellingAt = null;
            Long cancelledAt = null;
            BatchRequestCounts requestCounts = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("input_file_id".equals(fieldName)) {
                    inputFileId = reader.getString();
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    endpoint = reader.getString();
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    errors = BatchErrorList.fromJson(reader);
                    continue;
                }
                if ("completion_window".equals(fieldName)) {
                    completionWindow = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = BatchStatus.fromString(reader.getString());
                    continue;
                }
                if ("output_file_id".equals(fieldName)) {
                    outputFileId = reader.getString();
                    continue;
                }
                if ("error_file_id".equals(fieldName)) {
                    errorFileId = reader.getString();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("in_progress_at".equals(fieldName)) {
                    inProgressAt = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("expires_at".equals(fieldName)) {
                    expiresAt = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("finalizing_at".equals(fieldName)) {
                    finalizingAt = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("completed_at".equals(fieldName)) {
                    completedAt = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("failed_at".equals(fieldName)) {
                    failedAt = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("expired_at".equals(fieldName)) {
                    expiredAt = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cancelling_at".equals(fieldName)) {
                    cancellingAt = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cancelled_at".equals(fieldName)) {
                    cancelledAt = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("request_counts".equals(fieldName)) {
                    requestCounts = BatchRequestCounts.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            Batch deserializedBatch = new Batch(id, inputFileId);
            deserializedBatch.endpoint = endpoint;
            deserializedBatch.errors = errors;
            deserializedBatch.completionWindow = completionWindow;
            deserializedBatch.status = status;
            deserializedBatch.outputFileId = outputFileId;
            deserializedBatch.errorFileId = errorFileId;
            deserializedBatch.createdAt = createdAt;
            deserializedBatch.inProgressAt = inProgressAt;
            deserializedBatch.expiresAt = expiresAt;
            deserializedBatch.finalizingAt = finalizingAt;
            deserializedBatch.completedAt = completedAt;
            deserializedBatch.failedAt = failedAt;
            deserializedBatch.expiredAt = expiredAt;
            deserializedBatch.cancellingAt = cancellingAt;
            deserializedBatch.cancelledAt = cancelledAt;
            deserializedBatch.requestCounts = requestCounts;
            deserializedBatch.metadata = metadata;
            return deserializedBatch;
        });
    }

    private Batch(String id, String inputFileId) {
        this.id = id;
        this.inputFileId = inputFileId;
    }
}

