/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.controller.impl;

import com.katalon.capability.constant.DriverType;
import com.katalon.capability.controller.ICapabilityController;
import com.katalon.capability.dto.ImportCapabilityRequest;
import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.exception.WriteCapabilityException;
import com.katalon.capability.manager.ICapabilityManager;
import com.katalon.capability.model.CapabilitySetting;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CapabilityControllerImpl
implements ICapabilityController {
    private final ICapabilityManager capabilityManager;

    @Inject
    public CapabilityControllerImpl(ICapabilityManager capabilityManager) {
        this.capabilityManager = capabilityManager;
    }

    public CapabilitySetting getCapability(DriverType driverType) throws UnsupportedDriverTypeException {
        return this.capabilityManager.getCapability(driverType);
    }

    public void saveCapability(CapabilitySetting capabilitySetting) throws UnsupportedDriverTypeException, IOException, WriteCapabilityException {
        this.capabilityManager.saveCapability(capabilitySetting);
    }

    public void exportCapability(String exportFilePath, CapabilitySetting capabilitySetting) throws UnsupportedDriverTypeException, IOException {
        this.capabilityManager.exportCapability(exportFilePath, capabilitySetting);
    }

    public CapabilitySetting importCapability(ImportCapabilityRequest request) throws UnsupportedDriverTypeException {
        request.getDriverType();
        return this.capabilityManager.importCapability(request);
    }
}

