/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.file;

import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class IntegratedFileEntity
extends FileEntity {
    private static final long serialVersionUID = -7745543389066504753L;
    private List<IntegratedEntity> integratedEntities;

    public List<IntegratedEntity> getIntegratedEntities() {
        if (this.integratedEntities == null) {
            this.integratedEntities = new ArrayList<IntegratedEntity>();
        }
        return this.integratedEntities;
    }

    public void setIntegratedEntities(List<IntegratedEntity> integratedEntities) {
        this.integratedEntities = integratedEntities;
    }

    public IntegratedEntity getIntegratedEntity(String productName) {
        if (productName == null || productName.isEmpty()) {
            return null;
        }
        for (IntegratedEntity integratedEntity : this.getIntegratedEntities()) {
            if (!productName.equals(integratedEntity.getProductName())) continue;
            return integratedEntity;
        }
        return null;
    }

    public IntegratedFileEntity updateIntegratedEntity(IntegratedEntity integratedEntity) {
        if (integratedEntity == null || StringUtils.isEmpty((CharSequence)integratedEntity.getProductName())) {
            return this;
        }
        IntegratedEntity oldIntegrated = this.getIntegratedEntity(integratedEntity.getProductName());
        if (oldIntegrated == null) {
            this.integratedEntities.add(integratedEntity);
        } else {
            Map<String, String> properties = integratedEntity.getProperties();
            oldIntegrated.setProperties((Map<String, String>)(properties != null ? new HashMap<String, String>(properties) : Collections.emptyMap()));
        }
        return this;
    }
}

