/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.global;

import com.kms.katalon.entity.global.enums.VariableValueType;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class GlobalVariableEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ZERO_NUMBER = "0";
    public static final String EMPTY_STRING = "''";
    private String name;
    private String initValue;
    @XmlTransient
    private String protectedValue;
    private String description;
    private boolean isProtected;
    private VariableValueType valueType = null;

    public GlobalVariableEntity() {
        this("", EMPTY_STRING);
    }

    public GlobalVariableEntity(String name, String value) {
        this.setName(name);
        this.setInitValue(value);
        this.setProtectedValue(null);
        this.setValueType(null);
        this.setDescription("");
        this.setProtected(false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInitValue() {
        return this.initValue;
    }

    @XmlTransient
    public String getProtectedValue() {
        return this.protectedValue;
    }

    public String getValue() {
        if (this.isProtected()) {
            return this.getProtectedValue();
        }
        return this.initValue;
    }

    public void setInitValue(String initValue) {
        this.initValue = initValue;
    }

    @XmlTransient
    public void setProtectedValue(String protectedValue) {
        this.protectedValue = protectedValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public VariableValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(VariableValueType type) {
        this.valueType = type;
    }

    public boolean isDefaultValue() {
        String value = this.getValue();
        return EMPTY_STRING.equals(value) || ZERO_NUMBER.equals(value);
    }

    public String getDefaultValue() {
        if (this.getValueType() == VariableValueType.NUMBER) {
            return ZERO_NUMBER;
        }
        return EMPTY_STRING;
    }

    public GlobalVariableEntity clone() {
        GlobalVariableEntity newGlobalVariableEntity = new GlobalVariableEntity(this.getName(), this.getInitValue());
        newGlobalVariableEntity.setDescription(this.getDescription());
        newGlobalVariableEntity.setValueType(this.getValueType());
        newGlobalVariableEntity.setProtected(this.isProtected());
        return newGlobalVariableEntity;
    }

    public boolean equals(GlobalVariableEntity entity) {
        return this.getName().equals(entity.getName()) && this.getValue().equals(entity.getValue()) && this.getDescription().equals(entity.getDescription()) && this.getValueType().equals((Object)entity.getValueType()) && this.isProtected() == entity.isProtected();
    }

    public boolean equalsWithoutName(GlobalVariableEntity entity) {
        return this.getValue().equals(entity.getValue()) && this.getDescription().equals(entity.getDescription()) && this.getValueType().equals((Object)entity.getValueType()) && this.isProtected() == entity.isProtected();
    }
}

