/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.link;

import com.kms.katalon.entity.file.ClonableObject;
import java.util.ArrayList;
import java.util.List;

public class VariableLink
extends ClonableObject {
    private static final long serialVersionUID = 1L;
    private String variableId;
    private String value;
    private VariableType type;
    private String testDataLinkId;

    public VariableLink() {
        this.variableId = "";
        this.value = "";
        this.setType(VariableType.DEFAULT);
    }

    public VariableLink(String variableId) {
        this.variableId = variableId;
        this.value = "";
        this.testDataLinkId = "";
        this.setType(VariableType.DEFAULT);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public VariableType getType() {
        return this.type;
    }

    public void setType(VariableType type) {
        this.type = type;
    }

    public String getTestDataLinkId() {
        if (this.testDataLinkId == null) {
            this.testDataLinkId = "";
        }
        return this.testDataLinkId;
    }

    public void setTestDataLinkId(String testDataLinkId) {
        this.testDataLinkId = testDataLinkId;
    }

    @Override
    public VariableLink clone() {
        VariableLink newVariableLink = new VariableLink();
        newVariableLink.setTestDataLinkId(this.getTestDataLinkId());
        newVariableLink.setType(this.getType());
        newVariableLink.setValue(this.getValue());
        newVariableLink.setVariableId(this.getVariableId());
        return newVariableLink;
    }

    public static enum VariableType {
        DATA_COLUMN("Data Column"),
        DATA_COLUMN_INDEX("Data Column Index"),
        DEFAULT("Default"),
        SCRIPT_VARIABLE("Script Variable");

        private final String text;

        private VariableType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static VariableType fromValue(String v) {
            if (v == null) {
                return DEFAULT;
            }
            VariableType[] variableTypeArray = VariableType.values();
            int n = variableTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableType type = variableTypeArray[n2];
                if (type.toString().equals(v)) {
                    return type;
                }
                ++n2;
            }
            return VariableType.valueOf(v);
        }

        public static List<String> getValueStrings() {
            ArrayList<String> valueStrings = new ArrayList<String>();
            VariableType[] variableTypeArray = VariableType.values();
            int n = variableTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableType type = variableTypeArray[n2];
                valueStrings.add(type.toString());
                ++n2;
            }
            return valueStrings;
        }
    }
}

