/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.part;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPart;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.mobile.dialog.EditMobileElementPropertyDialog;
import com.kms.katalon.composer.mobile.dialog.NewMobileElementPropertyDialog;
import com.kms.katalon.composer.mobile.part.MobileTestObjectPropertiesTable;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.mobile.keyword.internal.MobileLocatorFinder;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MobileTestObjectPart
implements IComposerPart,
ModifyListener {
    private MobileElementEntity entity;
    private StyledText txtLocator;
    private MobileTestObjectPropertiesTable tableViewerObjectProperties;
    private Combo cbbLocatorStrategy;
    private MPart mpart;
    private Composite mainComposite;
    private Button btnGenerate;
    private static String[] strategies = LocatorStrategy.getStrategyNames();
    private List<WebElementPropertyEntity> properties = new ArrayList<WebElementPropertyEntity>();
    private MobileElementEntity editingEntity;
    private LocatorStrategy selectedLocatorStrategy;
    @Inject
    IEventBroker eventBroker;
    private EventServiceAdapter eventHandler = new EventServiceAdapter(){

        public void handleEvent(Event event) {
            Object[] objects = this.getObjects(event);
            if (objects == null || objects.length != 2) {
                return;
            }
            try {
                String oldWindowsObjectId = (String)objects[0];
                String newWindowsObjectId = (String)objects[1];
                if (MobileTestObjectPart.this.editingEntity.getIdForDisplay().equals(oldWindowsObjectId)) {
                    MobileTestObjectPart.this.entity = (MobileElementEntity)ObjectRepositoryController.getInstance().getWebElementByDisplayPk(newWindowsObjectId);
                    MobileTestObjectPart.this.editingEntity = (MobileElementEntity)MobileTestObjectPart.this.entity.clone();
                    MobileTestObjectPart.this.editingEntity.setName(MobileTestObjectPart.this.entity.getName());
                    MobileTestObjectPart.this.mpart.setLabel(MobileTestObjectPart.this.editingEntity.getName());
                }
            }
            catch (ControllerException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    };

    @PostConstruct
    public void onCreatePart(MPart mpart, Composite parent) {
        this.mpart = mpart;
        this.entity = (MobileElementEntity)mpart.getObject();
        this.editingEntity = (MobileElementEntity)this.entity.clone();
        this.properties = new ArrayList<WebElementPropertyEntity>(this.editingEntity.getWebElementProperties());
        Map locatorCollection = this.editingEntity.getLocatorCollection();
        MobileTestObject mobileTestObject = this.editingEntity.toMobileTestObject();
        LocatorStrategy[] locatorStrategyArray = LocatorStrategy.values();
        int n = locatorStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocatorStrategy locatorStrategy = locatorStrategyArray[n2];
            String locator = (String)locatorCollection.get(locatorStrategy);
            if (StringUtils.isBlank((CharSequence)locator)) {
                locator = MobileLocatorFinder.findLocator((TestObject)mobileTestObject, (LocatorStrategy)locatorStrategy);
                locatorCollection.put(locatorStrategy, locator);
            }
            ++n2;
        }
        MobilePlatform mobilePlatform = this.editingEntity.getPlatform();
        if (Objects.isNull(mobilePlatform)) {
            String type = this.getPropertyValue("type");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{type}) && StringUtils.contains((CharSequence)type, (CharSequence)"XCUI")) {
                this.editingEntity.setPlatform(MobilePlatform.IOS);
            } else {
                this.editingEntity.setPlatform(MobilePlatform.ANDROID);
            }
        }
        if (this.editingEntity.getPlatform() == MobilePlatform.IOS) {
            locatorStrategies = LocatorStrategy.getLocatorStrategies((MobilePlatform)MobilePlatform.IOS);
            strategies = (String[])locatorStrategies.stream().map(LocatorStrategy::getName).toArray(String[]::new);
        } else {
            locatorStrategies = LocatorStrategy.getLocatorStrategies((MobilePlatform)MobilePlatform.ANDROID);
            strategies = (String[])locatorStrategies.stream().map(LocatorStrategy::getName).toArray(String[]::new);
        }
        LocatorStrategy selectionLocatorStrategy = this.editingEntity.getLocatorStrategy();
        String locator = (String)locatorCollection.get(selectionLocatorStrategy);
        if (StringUtils.isBlank((CharSequence)locator) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{locator = this.editingEntity.getLocator()})) {
            locatorCollection.put(selectionLocatorStrategy, locator);
        }
        this.editingEntity.updateLocatorCollection(selectionLocatorStrategy, this.editingEntity.getLocator());
        this.selectedLocatorStrategy = this.editingEntity.getLocatorStrategy();
        this.createControls(parent);
        this.setInput();
        this.addListeners();
    }

    @PreDestroy
    public void onDestroyPart() {
        this.eventBroker.unsubscribe((EventHandler)this.eventHandler);
    }

    private void addListeners() {
        this.eventBroker.subscribe("EXPLORER/RENAMED_SELECTED_ITEM", (EventHandler)this.eventHandler);
        this.eventBroker.subscribe("EXPLORER/CUT_PASTED_SELECTED_ITEM", (EventHandler)this.eventHandler);
        this.btnGenerate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileTestObjectPart.this.updateLocator();
                MobileTestObjectPart.this.mpart.setDirty(true);
            }
        });
        this.cbbLocatorStrategy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LocatorStrategy locatorStrategy = LocatorStrategy.valueOfStrategy((String)MobileTestObjectPart.this.cbbLocatorStrategy.getText());
                if (!StringUtils.equals((CharSequence)MobileTestObjectPart.this.selectedLocatorStrategy.toString(), (CharSequence)locatorStrategy.toString())) {
                    Map locatorCollection = MobileTestObjectPart.this.editingEntity.getLocatorCollection();
                    locatorCollection.put(MobileTestObjectPart.this.selectedLocatorStrategy, MobileTestObjectPart.this.txtLocator.getText());
                    MobileTestObjectPart.this.selectedLocatorStrategy = locatorStrategy;
                    if (LocatorStrategy.ATTRIBUTES.equals((Object)MobileTestObjectPart.this.selectedLocatorStrategy)) {
                        MobileTestObjectPart.this.updateLocator();
                    } else {
                        MobileTestObjectPart.this.updateUIByLocatorStrategy(MobileTestObjectPart.this.selectedLocatorStrategy);
                    }
                    MobileTestObjectPart.this.mpart.setDirty(true);
                }
            }
        });
    }

    private void setInput() {
        this.mpart.setLabel(this.editingEntity.getName());
        this.tableViewerObjectProperties.setInput(this.properties);
        int selectedIndex = Arrays.asList(strategies).indexOf(this.selectedLocatorStrategy.getName());
        this.cbbLocatorStrategy.select(selectedIndex);
        this.updateUIByLocatorStrategy(this.selectedLocatorStrategy);
    }

    private void createControls(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setBackground(ColorUtil.getPartBackgroundColor());
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        Composite locatorMainComposite = new Composite(this.mainComposite, 0);
        locatorMainComposite.setLayout((Layout)new GridLayout(1, false));
        locatorMainComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblLocatorTitle = new Label(locatorMainComposite, 0);
        lblLocatorTitle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblLocatorTitle.setText("Locator");
        ControlUtils.setFontToBeBold((Control)lblLocatorTitle);
        Composite locatorDetailsComposite = new Composite(locatorMainComposite, 0);
        locatorDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout glLocatorDetails = new GridLayout();
        glLocatorDetails.marginWidth = 0;
        glLocatorDetails.marginHeight = 0;
        locatorDetailsComposite.setLayout((Layout)glLocatorDetails);
        Composite strategyLocatorComposite = new Composite(locatorDetailsComposite, 0);
        strategyLocatorComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout glStrategyLocator = new GridLayout(3, false);
        glStrategyLocator.marginWidth = 0;
        glStrategyLocator.marginHeight = 0;
        strategyLocatorComposite.setLayout((Layout)glStrategyLocator);
        Label lblLocatorStrategy = new Label(strategyLocatorComposite, 0);
        lblLocatorStrategy.setText("Locator Strategy");
        lblLocatorStrategy.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbbLocatorStrategy = new Combo(strategyLocatorComposite, 8);
        this.cbbLocatorStrategy.setItems(strategies);
        this.btnGenerate = new Button(strategyLocatorComposite, 8);
        this.btnGenerate.setText("Generate");
        Composite locatorComposite = new Composite(locatorDetailsComposite, 0);
        locatorComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        GridLayout glLocator = new GridLayout(2, false);
        glLocator.marginWidth = 0;
        glLocator.marginHeight = 0;
        locatorComposite.setLayout((Layout)glLocator);
        Label lblLocator = new Label(locatorComposite, 0);
        lblLocator.setLayoutData((Object)new GridData(16384, 128, false, false));
        lblLocator.setText("Locator");
        this.txtLocator = new StyledText(locatorComposite, 2624);
        GridData gdTxtEditor = new GridData(4, 4, true, false);
        gdTxtEditor.heightHint = 100;
        this.txtLocator.setLayoutData((Object)gdTxtEditor);
        Composite tableComposite = new Composite(this.mainComposite, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        GridLayout glTableComposite = new GridLayout();
        glTableComposite.marginTop = 15;
        tableComposite.setLayout((Layout)glTableComposite);
        Label lblObjectPropertiesTitle = new Label(tableComposite, 0);
        lblObjectPropertiesTitle.setText("Object Properties");
        ControlUtils.setFontToBeBold((Control)lblObjectPropertiesTitle);
        ToolBar tbProperties = new ToolBar(tableComposite, 0x820000);
        tbProperties.setForeground(ColorUtil.getToolBarForegroundColor());
        tbProperties.setLayoutData((Object)new GridData(4, 128, true, false));
        ToolItem tltmAdd = new ToolItem(tbProperties, 8);
        tltmAdd.setText("Add");
        tltmAdd.setImage(ImageManager.getImage((String)"add_16.png"));
        tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewMobileElementPropertyDialog windowsElementDialog = new NewMobileElementPropertyDialog(MobileTestObjectPart.this.getShell());
                if (windowsElementDialog.open() != 0) {
                    return;
                }
                MobileTestObjectPart.this.properties.add(windowsElementDialog.getNewProperty());
                MobileTestObjectPart.this.tableViewerObjectProperties.setInput(MobileTestObjectPart.this.properties);
                MobileTestObjectPart.this.tableViewerObjectProperties.refresh();
                if (OSUtil.isMacBigSurOrLater()) {
                    MobileTestObjectPart.this.tableViewerObjectProperties.getTable().redraw();
                }
                if (LocatorStrategy.ATTRIBUTES.equals((Object)MobileTestObjectPart.this.selectedLocatorStrategy)) {
                    MobileTestObjectPart.this.updateLocator();
                }
                MobileTestObjectPart.this.mpart.setDirty(true);
            }
        });
        ToolItem tltmEdit = new ToolItem(tbProperties, 8);
        tltmEdit.setText("Edit");
        tltmEdit.setImage(ImageManager.getImage((String)"edit_16.png"));
        tltmEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection = MobileTestObjectPart.this.tableViewerObjectProperties.getStructuredSelection();
                if (structuredSelection.isEmpty()) {
                    return;
                }
                WebElementPropertyEntity editingProperty = (WebElementPropertyEntity)structuredSelection.getFirstElement();
                EditMobileElementPropertyDialog windowsElementDialog = new EditMobileElementPropertyDialog(MobileTestObjectPart.this.getShell(), editingProperty);
                if (windowsElementDialog.open() != 0) {
                    return;
                }
                MobileTestObjectPart.this.tableViewerObjectProperties.refresh(editingProperty);
                if (OSUtil.isMacBigSurOrLater()) {
                    MobileTestObjectPart.this.tableViewerObjectProperties.getTable().redraw();
                }
                if (LocatorStrategy.ATTRIBUTES.equals((Object)MobileTestObjectPart.this.selectedLocatorStrategy)) {
                    MobileTestObjectPart.this.updateLocator();
                }
                MobileTestObjectPart.this.mpart.setDirty(true);
            }
        });
        ToolItem tltmDelete = new ToolItem(tbProperties, 8);
        tltmDelete.setText("Delete");
        tltmDelete.setImage(ImageManager.getImage((String)"delete_16.png"));
        tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List objects = MobileTestObjectPart.this.tableViewerObjectProperties.getStructuredSelection().toList();
                if (objects == null || objects.isEmpty()) {
                    return;
                }
                MobileTestObjectPart.this.properties.removeAll(objects);
                MobileTestObjectPart.this.tableViewerObjectProperties.refresh(true);
                if (OSUtil.isMacBigSurOrLater()) {
                    MobileTestObjectPart.this.tableViewerObjectProperties.getTable().redraw();
                }
                if (LocatorStrategy.ATTRIBUTES.equals((Object)MobileTestObjectPart.this.selectedLocatorStrategy)) {
                    MobileTestObjectPart.this.updateLocator();
                }
                MobileTestObjectPart.this.mpart.setDirty(true);
            }
        });
        ToolItem tltmClear = new ToolItem(tbProperties, 8);
        tltmClear.setText("Clear");
        tltmClear.setImage(ImageManager.getImage((String)"delete_16.png"));
        tltmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MobileTestObjectPart.this.properties.isEmpty()) {
                    return;
                }
                if (!MessageDialog.openConfirm((Shell)MobileTestObjectPart.this.getShell(), (String)GlobalStringConstants.CONFIRMATION, (String)"Do you want to clear all these properties?")) {
                    return;
                }
                MobileTestObjectPart.this.properties.clear();
                MobileTestObjectPart.this.tableViewerObjectProperties.setInput(MobileTestObjectPart.this.properties);
                MobileTestObjectPart.this.tableViewerObjectProperties.refresh();
                if (OSUtil.isMacBigSurOrLater()) {
                    MobileTestObjectPart.this.tableViewerObjectProperties.getTable().redraw();
                }
                if (LocatorStrategy.ATTRIBUTES.equals((Object)MobileTestObjectPart.this.selectedLocatorStrategy)) {
                    MobileTestObjectPart.this.updateLocator();
                }
                MobileTestObjectPart.this.mpart.setDirty(true);
            }
        });
        this.tableViewerObjectProperties = new MobileTestObjectPropertiesTable(tableComposite);
        this.tableViewerObjectProperties.addListener(new MobileTestObjectPropertiesTable.TestObjectPropertiesTableListener(){

            @Override
            public void onSelectProperties() {
                if (LocatorStrategy.ATTRIBUTES.equals((Object)MobileTestObjectPart.this.selectedLocatorStrategy)) {
                    MobileTestObjectPart.this.updateLocator();
                }
                MobileTestObjectPart.this.mpart.setDirty(true);
            }
        });
    }

    private void updateLocator() {
        MobileTestObject mobileTestObject = this.editingEntity.toMobileTestObject();
        String locator = MobileLocatorFinder.findLocator((TestObject)mobileTestObject, (LocatorStrategy)this.selectedLocatorStrategy);
        Map locatorCollection = this.editingEntity.getLocatorCollection();
        locatorCollection.put(this.selectedLocatorStrategy, locator);
        this.updateUIByLocatorStrategy(this.selectedLocatorStrategy);
    }

    private void updateUIByLocatorStrategy(LocatorStrategy selectedStrategy) {
        UISynchronizeService.asyncExec(() -> {
            Map locatorCollection = this.editingEntity.getLocatorCollection();
            String locator = (String)StringUtils.defaultIfBlank((CharSequence)((String)locatorCollection.get(selectedStrategy)), (CharSequence)"");
            this.txtLocator.setText(locator);
            if (LocatorStrategy.ATTRIBUTES.equals((Object)selectedStrategy)) {
                this.txtLocator.setEditable(false);
                this.txtLocator.removeModifyListener((ModifyListener)this);
                if (!ColorUtil.isDarkTheme()) {
                    this.txtLocator.setBackground(ColorUtil.getDisabledItemBackgroundColor());
                }
            } else {
                this.txtLocator.setEditable(true);
                this.txtLocator.removeModifyListener((ModifyListener)this);
                this.txtLocator.addModifyListener((ModifyListener)this);
                if (!ColorUtil.isDarkTheme()) {
                    this.txtLocator.setBackground(null);
                }
            }
            this.txtLocator.getParent().layout();
            this.tableViewerObjectProperties.updateUIByLocatorStrategy(selectedStrategy);
        });
    }

    private String getPropertyValue(String key) {
        WebElementPropertyEntity property;
        String value = "";
        Optional<WebElementPropertyEntity> firstEven = this.properties.stream().filter(p -> StringUtils.equalsIgnoreCase((CharSequence)p.getName(), (CharSequence)key)).findFirst();
        if (firstEven.isPresent() && Objects.nonNull(property = firstEven.get())) {
            value = property.getValue();
        }
        return value;
    }

    @Persist
    public void onSave() {
        LocatorStrategy selectedLocator = LocatorStrategy.valueOfStrategy((String)this.cbbLocatorStrategy.getText());
        String locator = this.txtLocator.getText();
        List list = (List)this.tableViewerObjectProperties.getInput();
        this.editingEntity.setLocatorStrategy(selectedLocator);
        this.editingEntity.setLocator(locator);
        this.editingEntity.updateLocatorCollection(selectedLocator, locator);
        this.editingEntity.setWebElementProperties(list.stream().map(WebElementPropertyEntity::clone).collect(Collectors.toList()));
        try {
            this.entity = this.editingEntity;
            ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)this.entity);
            WebElementTreeEntity treeEntity = TreeEntityUtil.getWebElementTreeEntity((WebElementEntity)this.entity, (ProjectEntity)this.entity.getProject());
            ExplorerPart.getInstance().refreshTreeEntity((Object)treeEntity.getParent());
            this.mpart.setDirty(false);
            Trackings.trackEditObject((String)"testObject", (String)"MOBILE");
            this.editingEntity = (MobileElementEntity)this.editingEntity.clone();
            this.properties = new ArrayList<WebElementPropertyEntity>(this.editingEntity.getWebElementProperties());
            this.setInput();
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Error", (String)"Unable to save mobile test object");
        }
    }

    public String getEntityId() {
        return this.entity.getIdForDisplay();
    }

    private Shell getShell() {
        return this.mainComposite.getShell();
    }

    public void modifyText(ModifyEvent e) {
        this.mpart.setDirty(true);
    }
}

