/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.preferences;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.mobile.constants.ComposerMobileMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.model.MobileDisplayObjectTreeOption;
import com.kms.katalon.execution.setting.MobileSettingStore;
import com.kms.katalon.tracking.service.Trackings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MobileSettingPage
extends PreferencePageWithHelp {
    private Composite container;
    private Combo displayObjectTreeOptions;
    private Combo defaultLocatorOptions;
    private String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
    private MobileSettingStore settingStore = new MobileSettingStore(this.projectDir);
    private boolean modified;
    private String LIGHT_THEME_INFORMATION_COLOR = "#666666";
    private String DARK_THEME_INFORMATION_COLOR = "#CCCCCC";
    private int MARGIN_BETWEEN_TWO_OPTIONS = 12;
    private int COMBO_WIDTH = 150;
    private String[] locatorStrategies;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createObjectTreeOptionContent(this.container);
        ComponentBuilder.separator2((Composite)this.container, (int)1, (String)"#CECFCF", (String)"#626768").build();
        this.createDefaultLocatorContent(this.container);
        this.initValue();
        this.registerControlModifyListeners();
        return parent;
    }

    private void createObjectTreeOptionContent(Composite parent) {
        Composite composite = new Composite(this.container, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginRight = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        ComponentBuilder.label((Composite)composite).text(ComposerMobileMessageConstants.DEFAULT_DISPLAYING_OBJECT_TREE).build();
        ComponentBuilder.helpButton((Composite)composite, (String)ComposerMobileMessageConstants.LINK_TO_DISPLAY_OBJECT_TREE_OPTIONS).marginRight(95).build();
        this.displayObjectTreeOptions = (Combo)ComponentBuilder.comboBox((Composite)composite, (int)8).width(this.COMBO_WIDTH).build();
        Label lblObjectTreeOption = (Label)ComponentBuilder.label((Composite)this.container).text(ComposerMobileMessageConstants.DESCRIPTION_DISPLAY_OBJECT_TREE_OPTIONS).italic().marginBottom(this.MARGIN_BETWEEN_TWO_OPTIONS).build();
        lblObjectTreeOption.setForeground(ColorUtil.themeColor((String)this.LIGHT_THEME_INFORMATION_COLOR, (String)this.DARK_THEME_INFORMATION_COLOR));
    }

    private void createDefaultLocatorContent(Composite parent) {
        Composite composite = new Composite(this.container, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginRight = 0;
        layout.marginHeight = 0;
        layout.marginTop = 8;
        composite.setLayout((Layout)layout);
        ComponentBuilder.label((Composite)composite).text(ComposerMobileMessageConstants.DESCRIPTION_MOBILE_NATIVE_APP_DEFAULT_LOCATOR).build();
        ComponentBuilder.helpButton((Composite)composite, (String)ComposerMobileMessageConstants.LINK_TO_MOBILE_NATIVE_APP_DEFAULT_LOCATOR).marginRight(12).build();
        this.defaultLocatorOptions = (Combo)ComponentBuilder.comboBox((Composite)composite, (int)8).width(this.COMBO_WIDTH).build();
        Label lblDefaultLocator = (Label)ComponentBuilder.label((Composite)this.container).text(ComposerMobileMessageConstants.MOBILE_DEFAULT_LOCATOR_INFORMATION).italic().color(ColorUtil.themeColor((String)this.LIGHT_THEME_INFORMATION_COLOR, (String)this.DARK_THEME_INFORMATION_COLOR)).build();
        lblDefaultLocator.setForeground(ColorUtil.themeColor((String)this.LIGHT_THEME_INFORMATION_COLOR, (String)this.DARK_THEME_INFORMATION_COLOR));
    }

    private void initValue() {
        this.displayObjectTreeOptions.setItems(MobileDisplayObjectTreeOption.valueStrings());
        MobileDisplayObjectTreeOption defaultDisplayObjectTreOption = this.settingStore.getDefaultMobileDisplayObjectTreeOption();
        this.displayObjectTreeOptions.select(defaultDisplayObjectTreOption.ordinal());
        this.locatorStrategies = LocatorStrategy.getStrategyNames();
        this.defaultLocatorOptions.setItems(this.locatorStrategies);
        this.defaultLocatorOptions.select(this.settingStore.getDefaultLocatorStrategy().ordinal());
        this.modified = false;
    }

    private void registerControlModifyListeners() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileSettingPage.this.modified = true;
            }
        };
        this.displayObjectTreeOptions.addSelectionListener((SelectionListener)listener);
        this.defaultLocatorOptions.addSelectionListener((SelectionListener)listener);
    }

    protected void performDefaults() {
        MobileDisplayObjectTreeOption defaultDisplayObjectTreOption = MobileSettingStore.DEFAULT_DISPLAY_TREE_OPTION_IF_NOT_SET;
        this.displayObjectTreeOptions.select(defaultDisplayObjectTreOption.ordinal());
        this.modified = true;
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.container == null) {
            return true;
        }
        String selectingLocatorStrategy = this.locatorStrategies[this.defaultLocatorOptions.getSelectionIndex()];
        if (this.modified) {
            this.settingStore.saveDefaultOptionDisplayTree(MobileDisplayObjectTreeOption.valueStrings()[this.displayObjectTreeOptions.getSelectionIndex()]);
            this.settingStore.setDefaultLocatorStrategy(selectingLocatorStrategy);
        }
        Trackings.trackMobileDefaultLocator((String)selectingLocatorStrategy.toLowerCase());
        return super.performOk();
    }

    public boolean hasDocumentation() {
        return false;
    }
}

