/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.platform.internal.entity.testobject;

import com.katalon.platform.api.model.testobject.RestRequestEntity;
import com.katalon.platform.api.model.testobject.WebServiceProperty;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.platform.internal.entity.VariableEntityImpl;
import com.kms.katalon.platform.internal.entity.testobject.WebServicePropertyImpl;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RestRequestEntityImpl
implements RestRequestEntity {
    private final WebServiceRequestEntity source;

    public RestRequestEntityImpl(WebServiceRequestEntity source) {
        this.source = source;
    }

    public List<WebServiceProperty> getHttpHeaders() {
        if (this.source.getHttpHeaderProperties() == null) {
            return Collections.emptyList();
        }
        return this.source.getHttpHeaderProperties().stream().map(header -> new WebServicePropertyImpl((WebElementPropertyEntity)header)).collect(Collectors.toList());
    }

    public String getRequestMethod() {
        return this.source.getRestRequestMethod();
    }

    public List<WebServiceProperty> getRequestParameters() {
        if (this.source.getRestParameters() == null) {
            return Collections.emptyList();
        }
        return this.source.getRestParameters().stream().map(param -> new WebServicePropertyImpl((WebElementPropertyEntity)param)).collect(Collectors.toList());
    }

    public String getRequestUrl() {
        return this.source.getRestUrl();
    }

    public String getServiceType() {
        return this.source.getServiceType();
    }

    public List<com.katalon.platform.api.model.VariableEntity> getVariables() {
        if (this.source.getVariables() == null) {
            return Collections.emptyList();
        }
        return this.source.getVariables().stream().map(variable -> new VariableEntityImpl((VariableEntity)variable)).collect(Collectors.toList());
    }

    public String getVerificationScript() {
        return this.source.getVerificationScript();
    }

    public String getFileLocation() {
        return this.source.getId();
    }

    public String getFolderLocation() {
        return this.source.getParentFolder().getLocation();
    }

    public String getId() {
        return this.source.getIdForDisplay();
    }

    public String getName() {
        return this.source.getName();
    }

    public String getHttpBodyContent() {
        return this.source.getHttpBodyContent();
    }

    public String getHttpBodyType() {
        return this.source.getHttpBodyType();
    }

    public String getDescription() {
        return this.source.getDescription();
    }
}

