/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.dialog;

import com.kms.katalon.composer.components.impl.dialogs.CommonPropertiesDialog;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TestSuiteCollectionPropertiesDialog
extends CommonPropertiesDialog<TestSuiteCollectionEntity> {
    private Text txtCreatedDate;
    private Text txtModifiedDate;
    private Text txtTag;

    public TestSuiteCollectionPropertiesDialog(Shell parentShell, TestSuiteCollectionEntity entity) {
        super(parentShell, (FileEntity)entity);
        this.setDialogTitle(ComposerTestsuiteCollectionMessageConstants.DIA_TITLE_TEST_COLLECTION_SUITE_PROPERTIES);
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = (Composite)super.createDialogContainer(parent);
        Label lblTag = new Label(container, 0);
        lblTag.setText(GlobalStringConstants.TAG);
        this.txtTag = new Text(container, 2048);
        this.txtTag.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblCreatedDate = new Label(container, 0);
        lblCreatedDate.setText(ComposerTestsuiteCollectionMessageConstants.PA_LBL_CREATED_DATE);
        this.txtCreatedDate = new Text(container, 2056);
        this.txtCreatedDate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblModifiedDate = new Label(container, 0);
        lblModifiedDate.setText(ComposerTestsuiteCollectionMessageConstants.PA_LBL_LAST_UPDATED);
        this.txtModifiedDate = new Text(container, 2056);
        this.txtModifiedDate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        return container;
    }

    protected void setInput() {
        super.setInput();
        TestSuiteCollectionEntity testSuiteCollection = (TestSuiteCollectionEntity)this.getEntity();
        this.txtTag.setText(StringUtils.defaultString((String)testSuiteCollection.getTag()));
        this.txtCreatedDate.setText(testSuiteCollection.getDateCreated().toString());
        this.txtModifiedDate.setText(testSuiteCollection.getDateModified().toString());
    }

    protected void updateChanges() {
        if (!this.isModified()) {
            return;
        }
        TestSuiteCollectionEntity testSuiteCollection = (TestSuiteCollectionEntity)this.getEntity();
        testSuiteCollection.setDescription(this.txtDescription.getText());
        testSuiteCollection.setTag(this.txtTag.getText());
    }

    protected void registerControlModifyListeners() {
        super.registerControlModifyListeners();
        this.txtTag.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestSuiteCollectionPropertiesDialog.this.setModified(true);
            }
        });
    }
}

