/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.api.network;

import com.katalon.platform.api.preference.ApplicationPreference;
import com.katalon.platform.api.service.ApplicationManager;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ApplicationProxyPreference {
    public static final String PROXY_PREFERENCE_ID = "com.kms.katalon.execution";

    @Deprecated
    public static boolean isProxyPreferencesSet() {
        ApplicationPreference store = ApplicationProxyPreference.getPreferenceStore();
        return store.getBoolean("proxy.preferences.set", false);
    }

    @Deprecated
    public static ProxyInformation getProxyInformation() {
        ApplicationPreference store = ApplicationProxyPreference.getPreferenceStore();
        ProxyInformation proxyInfo = new ProxyInformation();
        proxyInfo.setProxyOption((String)StringUtils.defaultIfEmpty((CharSequence)store.getString("proxy.option", ""), (CharSequence)ProxyOption.NO_PROXY.name()));
        proxyInfo.setProxyServerType((String)StringUtils.defaultIfEmpty((CharSequence)store.getString("proxy.server.type", ""), (CharSequence)ProxyServerType.HTTP.name()));
        proxyInfo.setProxyServerAddress(store.getString("proxy.server.address", ""));
        proxyInfo.setProxyServerPort(store.getInt("proxy.server.port", 0));
        proxyInfo.setUsername(store.getString("proxy.username", ""));
        proxyInfo.setPassword(store.getString("proxy.password", ""));
        proxyInfo.setExceptionList(store.getString("proxy.excludes", ""));
        return proxyInfo;
    }

    public static boolean isAuthProxyPreferencesSet() {
        ApplicationPreference store = ApplicationProxyPreference.getPreferenceStore();
        return store.getBoolean("proxy.auth.preferences.set", false);
    }

    public static ProxyInformation getAuthProxyInformation() {
        if (!ApplicationProxyPreference.isAuthProxyPreferencesSet()) {
            return ApplicationProxyPreference.getProxyInformation();
        }
        ApplicationPreference store = ApplicationProxyPreference.getPreferenceStore();
        ProxyInformation proxyInfo = new ProxyInformation();
        proxyInfo.setProxyOption((String)StringUtils.defaultIfEmpty((CharSequence)store.getString("proxy.auth.option", ""), (CharSequence)ProxyOption.NO_PROXY.name()));
        proxyInfo.setProxyServerType((String)StringUtils.defaultIfEmpty((CharSequence)store.getString("proxy.auth.server.type", ""), (CharSequence)ProxyServerType.HTTP.name()));
        proxyInfo.setProxyServerAddress(store.getString("proxy.auth.server.address", ""));
        proxyInfo.setProxyServerPort(store.getInt("proxy.auth.server.port", 0));
        proxyInfo.setUsername(store.getString("proxy.auth.username", ""));
        proxyInfo.setPassword(store.getString("proxy.auth.password", ""));
        proxyInfo.setExceptionList(store.getString("proxy.auth.excludes", ""));
        return proxyInfo;
    }

    public static boolean isSystemProxyPreferencesSet() {
        ApplicationPreference store = ApplicationProxyPreference.getPreferenceStore();
        return store.getBoolean("proxy.system.preferences.set", false);
    }

    public static ProxyInformation getSystemProxyInformation() {
        if (!ApplicationProxyPreference.isSystemProxyPreferencesSet()) {
            ProxyInformation proxyInfo = ApplicationProxyPreference.getProxyInformation();
            proxyInfo.setApplyToDesiredCapabilities(true);
            return proxyInfo;
        }
        ApplicationPreference store = ApplicationProxyPreference.getPreferenceStore();
        ProxyInformation proxyInfo = new ProxyInformation();
        proxyInfo.setProxyOption((String)StringUtils.defaultIfEmpty((CharSequence)store.getString("proxy.system.option", ""), (CharSequence)ProxyOption.NO_PROXY.name()));
        proxyInfo.setProxyServerType((String)StringUtils.defaultIfEmpty((CharSequence)store.getString("proxy.system.server.type", ""), (CharSequence)ProxyServerType.HTTP.name()));
        proxyInfo.setProxyServerAddress(store.getString("proxy.system.server.address", ""));
        proxyInfo.setProxyServerPort(store.getInt("proxy.system.server.port", 0));
        proxyInfo.setUsername(store.getString("proxy.system.username", ""));
        proxyInfo.setPassword(store.getString("proxy.system.password", ""));
        proxyInfo.setExceptionList(store.getString("proxy.system.excludes", ""));
        proxyInfo.setApplyToDesiredCapabilities(store.getBoolean("proxy.system.applyToDesiredCapabilities", false));
        return proxyInfo;
    }

    private static ApplicationPreference getPreferenceStore() {
        return ApplicationManager.getInstance().getPreferenceManager().getApplicationPreference(PROXY_PREFERENCE_ID);
    }

    public static enum ProxyServerType {
        HTTP,
        HTTPS,
        SOCKS;


        public static String[] stringValues() {
            ProxyServerType[] values = ProxyServerType.values();
            return Arrays.asList(values).stream().map(proxyServerType -> proxyServerType.toString()).collect(Collectors.toList()).toArray(new String[values.length]);
        }
    }

    public static enum ProxyOption {
        NO_PROXY("No Proxy"),
        USE_SYSTEM("Use system proxy configuration"),
        MANUAL_CONFIG("Manual proxy configuration");

        private String displayName;

        private ProxyOption(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static String[] stringValues() {
            ProxyOption[] values = ProxyOption.values();
            return Arrays.asList(values).stream().map(proxyServerType -> proxyServerType.toString()).collect(Collectors.toList()).toArray(new String[values.length]);
        }

        public static String[] displayStringValues() {
            ProxyOption[] values = ProxyOption.values();
            return Arrays.asList(values).stream().map(proxyServerType -> proxyServerType.getDisplayName()).collect(Collectors.toList()).toArray(new String[values.length]);
        }

        public static ProxyOption valueOfDisplayName(String displayName) {
            return Arrays.asList(ProxyOption.values()).parallelStream().filter(proxyOption -> proxyOption.getDisplayName().equals(displayName)).findAny().orElse(null);
        }
    }

    public static class ProxyInformation {
        private String proxyOption;
        private String proxyServerType;
        private String username;
        private String password;
        private String proxyServerAddress;
        private int proxyServerPort;
        private String exceptionList;
        private boolean applyToDesiredCapabilities;

        public String getExceptionList() {
            return this.exceptionList;
        }

        public void setExceptionList(String exceptionList) {
            this.exceptionList = StringUtils.isNotEmpty((CharSequence)exceptionList) ? exceptionList : "";
        }

        public String getProxyOption() {
            return this.proxyOption;
        }

        public void setProxyOption(String proxyOption) {
            if (StringUtils.isEmpty((CharSequence)proxyOption)) {
                proxyOption = ProxyOption.NO_PROXY.name();
            }
            this.proxyOption = proxyOption;
        }

        public String getProxyServerType() {
            return this.proxyServerType;
        }

        public void setProxyServerType(String proxyServerType) {
            this.proxyServerType = StringUtils.isNotEmpty((CharSequence)proxyServerType) ? proxyServerType : "";
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = StringUtils.isNotEmpty((CharSequence)username) ? username : "";
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = StringUtils.isNotEmpty((CharSequence)password) ? password : "";
        }

        public String getProxyServerAddress() {
            return this.proxyServerAddress;
        }

        public void setProxyServerAddress(String proxyServerAddress) {
            this.proxyServerAddress = StringUtils.isNotEmpty((CharSequence)proxyServerAddress) ? proxyServerAddress : "";
        }

        public int getProxyServerPort() {
            return this.proxyServerPort;
        }

        public void setProxyServerPort(int proxyServerPort) {
            this.proxyServerPort = proxyServerPort;
        }

        public void setProxyServerPort(String proxyServerPort) {
            try {
                this.proxyServerPort = Integer.parseInt(StringUtils.isNotEmpty((CharSequence)proxyServerPort) ? proxyServerPort : "-1");
            }
            catch (NumberFormatException ex) {
                this.proxyServerPort = -1;
            }
        }

        public boolean isApplyToDesiredCapabilities() {
            return this.applyToDesiredCapabilities;
        }

        public void setApplyToDesiredCapabilities(boolean applyToDesiredCapabilities) {
            this.applyToDesiredCapabilities = applyToDesiredCapabilities;
        }

        public String toString() {
            return "ProxyInformation { proxyOption=" + this.proxyOption + ", proxyServerType=" + this.proxyServerType + ", username=" + this.username + ", password=********, proxyServerAddress=" + this.proxyServerAddress + ", proxyServerPort=" + this.proxyServerPort + ", executionList=\"" + this.exceptionList + "\", isApplyToDesiredCapabilities=" + this.applyToDesiredCapabilities + " }";
        }
    }

    public static interface ProxyPreferenceConstants {
        public static final String PROXY_OPTION = "proxy.option";
        public static final String PROXY_SERVER_TYPE = "proxy.server.type";
        public static final String PROXY_SERVER_ADDRESS = "proxy.server.address";
        public static final String PROXY_SERVER_PORT = "proxy.server.port";
        public static final String PROXY_USERNAME = "proxy.username";
        public static final String PROXY_PASSWORD = "proxy.password";
        public static final String PROXY_EXCEPTION_LIST = "proxy.excludes";
        public static final String PROXY_PREFERENCE_SET = "proxy.preferences.set";
        public static final String AUTH_PROXY_OPTION = "proxy.auth.option";
        public static final String AUTH_PROXY_SERVER_TYPE = "proxy.auth.server.type";
        public static final String AUTH_PROXY_SERVER_ADDRESS = "proxy.auth.server.address";
        public static final String AUTH_PROXY_SERVER_PORT = "proxy.auth.server.port";
        public static final String AUTH_PROXY_USERNAME = "proxy.auth.username";
        public static final String AUTH_PROXY_PASSWORD = "proxy.auth.password";
        public static final String AUTH_PROXY_EXCEPTION_LIST = "proxy.auth.excludes";
        public static final String AUTH_PROXY_PREFERENCE_SET = "proxy.auth.preferences.set";
        public static final String SYSTEM_PROXY_OPTION = "proxy.system.option";
        public static final String SYSTEM_PROXY_SERVER_TYPE = "proxy.system.server.type";
        public static final String SYSTEM_PROXY_SERVER_ADDRESS = "proxy.system.server.address";
        public static final String SYSTEM_PROXY_SERVER_PORT = "proxy.system.server.port";
        public static final String SYSTEM_PROXY_USERNAME = "proxy.system.username";
        public static final String SYSTEM_PROXY_PASSWORD = "proxy.system.password";
        public static final String SYSTEM_PROXY_EXCEPTION_LIST = "proxy.system.excludes";
        public static final String SYSTEM_PROXY_APPLY_TO_DESIRED_CAPABILITIES = "proxy.system.applyToDesiredCapabilities";
        public static final String SYSTEM_PROXY_PREFERENCE_SET = "proxy.system.preferences.set";
    }
}

