/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.api.network;

import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.preference.PluginPreference;
import com.katalon.platform.api.service.ApplicationManager;

public class NetworkPreference {
    private static final String NETWORK_PREFERENCE_ID = "com.kms.katalon.core.webservice";
    private final String projectId;
    private final PluginPreference pluginPreference;

    public NetworkPreference(String projectId) throws ResourceException {
        this.projectId = projectId;
        this.pluginPreference = ApplicationManager.getInstance().getPreferenceManager().getInternalPluginPreference(projectId, NETWORK_PREFERENCE_ID);
    }

    public SSLCertificateOption getSSLCertificateOption() {
        return SSLCertificateOption.valueOf(this.pluginPreference.getString("network.sslCert", SSLCertificateOption.BYPASS.name()));
    }

    public boolean isByPassSSLCertificate() {
        return this.getSSLCertificateOption() == SSLCertificateOption.BYPASS;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public static interface NetworkPreferenceConstants {
        public static final String SETTING_SSL_CERTIFICATE = "network.sslCert";
    }

    public static enum SSLCertificateOption {
        NONE,
        BYPASS;

    }
}

