/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.eclipse.adapters.ClassFileEditorAdapterFactory;
import org.codehaus.groovy.eclipse.adapters.GroovyIFileEditorInputAdapterFactory;
import org.codehaus.groovy.eclipse.debug.EvaluationEngine;
import org.codehaus.groovy.eclipse.debug.ui.EnsureJUnitFont;
import org.codehaus.groovy.eclipse.debug.ui.GroovyDebugOptionsEnforcer;
import org.codehaus.groovy.eclipse.debug.ui.GroovyJavaDebugElementAdapterFactory;
import org.codehaus.groovy.eclipse.editor.GroovyAwareFoldingStructureProvider;
import org.codehaus.groovy.eclipse.editor.GroovyOutlineTools;
import org.codehaus.groovy.eclipse.editor.GroovyTextTools;
import org.codehaus.groovy.eclipse.refactoring.actions.DelegatingCleanUpPostSaveListener;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.text.folding.JavaFoldingStructureProviderRegistry;
import org.eclipse.jdt.ui.text.folding.DefaultJavaFoldingStructureProvider;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GroovyPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.codehaus.groovy.eclipse.ui";
    public static final String GROOVY_TEMPLATE_CTX = "org.codehaus.groovy.eclipse.templates";
    public static final String COMPILER_MISMATCH_MARKER = "org.codehaus.groovy.eclipse.core.compilerMismatch";
    private static GroovyPlugin plugin;
    private EnsureJUnitFont junitMono;
    private GroovyTextTools textTools;
    private GroovyOutlineTools outlineTools;

    public static GroovyPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchWindow window = GroovyPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = GroovyPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell shell = window.getShell();
        if (shell == null) {
            shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        }
        return shell;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (plugin == null) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }

    public static void trace(String message) {
        if (plugin.isDebugging()) {
            System.out.println(message);
        }
    }

    public GroovyPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.textTools = new GroovyTextTools();
        this.outlineTools = new GroovyOutlineTools();
        this.addMonospaceFontListener();
        this.setStructureProviderRegistry();
        DelegatingCleanUpPostSaveListener.installCleanUp();
        IAdapterManager adapterManager = Platform.getAdapterManager();
        adapterManager.registerAdapters((IAdapterFactory)new ClassFileEditorAdapterFactory(), ClassFileEditor.class);
        adapterManager.registerAdapters((IAdapterFactory)new GroovyJavaDebugElementAdapterFactory(), IJavaStackFrame.class);
        adapterManager.registerAdapters((IAdapterFactory)new GroovyIFileEditorInputAdapterFactory(), IFileEditorInput.class);
        if (Boolean.parseBoolean(System.getProperty("eclipse.groovy.debug", "true"))) {
            this.addDebugLaunchListener();
        }
        if (this.getPreferenceStore().getBoolean("groovy.debug.force_options")) {
            new GroovyDebugOptionsEnforcer().maybeForce(this.getPreferenceStore());
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.textTools.dispose();
            this.textTools = null;
            this.outlineTools.dispose();
            this.outlineTools = null;
            this.removeMonospaceFontListener();
            DelegatingCleanUpPostSaveListener.uninstallCleanUp();
        }
        finally {
            super.stop(context);
        }
    }

    private void addDebugLaunchListener() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(new ILaunchListener(){

            public void launchAdded(ILaunch launch) {
            }

            public void launchChanged(ILaunch launch) {
                IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
                int n = iDebugTargetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDebugTarget target = iDebugTargetArray[n2];
                    if (target instanceof IJavaDebugTarget) {
                        try {
                            if (ReflectionUtils.throwableGetPrivateField(target.getClass(), (String)"fEngines", (Object)target) == null) {
                                ReflectionUtils.throwableSetPrivateField(target.getClass(), (String)"fEngines", (Object)target, (Object)GroovyPlugin.evalEngineInterceptor(target));
                            }
                        }
                        catch (Exception e) {
                            GroovyPlugin.this.logError("Error installing evaluation engine hooks", e);
                        }
                    }
                    ++n2;
                }
            }

            public void launchRemoved(ILaunch launch) {
            }
        });
    }

    private void addMonospaceFontListener() {
        this.junitMono = new EnsureJUnitFont();
        try {
            if (PlatformUI.isWorkbenchRunning() && GroovyPlugin.getActiveWorkbenchPage() != null) {
                GroovyPlugin.getActiveWorkbenchPage().addPartListener((IPartListener2)this.junitMono);
            }
            this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.junitMono);
            PrefUtil.getInternalPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.junitMono);
        }
        catch (Exception e) {
            this.logError("Error installing JUnit monospace font listener", e);
        }
    }

    private void removeMonospaceFontListener() {
        try {
            try {
                if (!PlatformUI.getWorkbench().isClosing()) {
                    GroovyPlugin.getActiveWorkbenchPage().removePartListener((IPartListener2)this.junitMono);
                }
            }
            catch (RuntimeException runtimeException) {
                PrefUtil.getInternalPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
                this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
                this.junitMono = null;
            }
        }
        finally {
            PrefUtil.getInternalPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.junitMono);
            this.junitMono = null;
        }
    }

    private void setStructureProviderRegistry() {
        try {
            ReflectionUtils.setPrivateField(JavaPlugin.class, (String)"fFoldingStructureProviderRegistry", (Object)JavaPlugin.getDefault(), (Object)new JavaFoldingStructureProviderRegistry(){

                public IJavaFoldingStructureProvider getCurrentFoldingProvider() {
                    Object provider = super.getCurrentFoldingProvider();
                    if (provider.getClass().equals(DefaultJavaFoldingStructureProvider.class)) {
                        provider = new GroovyAwareFoldingStructureProvider();
                    }
                    return provider;
                }
            });
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public GroovyTextTools getTextTools() {
        return this.textTools;
    }

    public GroovyOutlineTools getOutlineTools() {
        return this.outlineTools;
    }

    public void logMessage(String message) {
        this.log(1, message, null);
    }

    public void logWarning(String message) {
        this.log(2, message, null);
    }

    public void logError(String message, Throwable error) {
        this.log(4, message, error);
    }

    private void log(int severity, String message, Throwable cause) {
        this.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message, cause));
    }

    private static Object evalEngineInterceptor(final IDebugTarget target) {
        return Collections.synchronizedMap(new AbstractMap<IJavaProject, IAstEvaluationEngine>(){
            private Set<Map.Entry<IJavaProject, IAstEvaluationEngine>> entries = new HashSet<Map.Entry<IJavaProject, IAstEvaluationEngine>>(2);

            @Override
            public Set<Map.Entry<IJavaProject, IAstEvaluationEngine>> entrySet() {
                return this.entries;
            }

            @Override
            public IAstEvaluationEngine get(Object key) {
                IJavaProject javaProject;
                if (!this.containsKey(key) && key instanceof IJavaProject && GroovyNature.hasGroovyNature((IProject)(javaProject = (IJavaProject)key).getProject())) {
                    EvaluationEngine evalEngine = new EvaluationEngine(javaProject, (IJavaDebugTarget)target);
                    this.entries.add(new AbstractMap.SimpleEntry<IJavaProject, EvaluationEngine>(javaProject, evalEngine));
                    return evalEngine;
                }
                return (IAstEvaluationEngine)super.get(key);
            }

            @Override
            public IAstEvaluationEngine put(IJavaProject key, IAstEvaluationEngine value) {
                if (GroovyNature.hasGroovyNature((IProject)key.getProject())) {
                    value.dispose();
                    value = new EvaluationEngine(key, (IJavaDebugTarget)target);
                }
                for (Map.Entry<IJavaProject, IAstEvaluationEngine> entry : this.entrySet()) {
                    if (!entry.getKey().equals(key)) continue;
                    return entry.setValue(value);
                }
                this.entries.add(new AbstractMap.SimpleEntry<IJavaProject, IAstEvaluationEngine>(key, value));
                return null;
            }
        });
    }
}

