/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.actions;

import java.text.MessageFormat;
import java.util.Optional;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

public abstract class AbstractClasspathContainerAction
implements IActionDelegate {
    protected final String containerName;
    protected final IPath containerPath;
    protected IJavaProject targetProject;

    protected AbstractClasspathContainerAction(String containerName, IPath containerPath) {
        this.containerName = containerName;
        this.containerPath = containerPath;
    }

    public void run(IAction action) {
        try {
            Optional optEntry = GroovyRuntime.findClasspathEntry((IJavaProject)this.targetProject, cpe -> cpe.getPath().matchingFirstSegments(this.containerPath) > 0);
            if (!optEntry.isPresent()) {
                IClasspathAttribute[] iClasspathAttributeArray;
                if (JavaRuntime.isModularProject((IJavaProject)this.targetProject)) {
                    IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
                    iClasspathAttributeArray = iClasspathAttributeArray2;
                    iClasspathAttributeArray2[0] = JavaCore.newClasspathAttribute((String)"module", (String)"true");
                } else {
                    iClasspathAttributeArray = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
                }
                IClasspathEntry newEntry = JavaCore.newContainerEntry((IPath)this.containerPath, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])iClasspathAttributeArray, (boolean)false);
                GroovyRuntime.appendClasspathEntry((IJavaProject)this.targetProject, (IClasspathEntry)newEntry);
            } else {
                GroovyRuntime.removeClasspathEntry((IJavaProject)this.targetProject, (IClasspathEntry)((IClasspathEntry)optEntry.get()));
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)MessageFormat.format("Failed to add or remove {0} classpath container", this.containerName), (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IJavaProject selectedProject;
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IProject) {
                IProject selectedProject2 = (IProject)selected;
                if (GroovyNature.hasGroovyNature((IProject)selectedProject2)) {
                    this.targetProject = JavaCore.create((IProject)selectedProject2);
                }
            } else if (selected instanceof IJavaProject && GroovyNature.hasGroovyNature((IProject)(selectedProject = (IJavaProject)selected).getProject())) {
                this.targetProject = selectedProject;
            }
        }
        if (this.targetProject != null && this.targetProject.exists()) {
            action.setEnabled(true);
            try {
                if (GroovyRuntime.findClasspathEntry((IJavaProject)this.targetProject, cpe -> cpe.getPath().matchingFirstSegments(this.containerPath) > 0).isPresent()) {
                    action.setText(MessageFormat.format("Remove {0} from project", this.containerName));
                } else {
                    boolean isModular = JavaProject.hasJavaNature((IProject)this.targetProject.getProject()) && this.targetProject.getModuleDescription() != null;
                    action.setText(MessageFormat.format("Add {0} to {1,choice,0#classpath|1#modulepath}", this.containerName, isModular ? 1 : 0));
                }
                return;
            }
            catch (JavaModelException e) {
                GroovyCore.logException((String)MessageFormat.format("Failed to update {0} classpath container action", this.containerName), (Throwable)e);
            }
        }
        action.setEnabled(false);
        action.setText(MessageFormat.format("Cannot add or remove {0} classpath container", this.containerName));
    }
}

