/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.actions;

import java.util.ArrayList;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class CompilerMismatchMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (marker.getResource().getType() == 4) {
            return new IMarkerResolution[]{new ConfigureCompilerLevelResolution(marker), new SetToWorkspaceCompilerLevelResolution(marker), new ConfigureWorksaceCompilerLevelResolution(marker)};
        }
        return new IMarkerResolution[0];
    }

    private static abstract class AbstractCompilerConfigurator
    extends WorkbenchMarkerResolution
    implements IMarkerResolution2 {
        private final IMarker thisMarker;

        AbstractCompilerConfigurator(IMarker thisMarker) {
            this.thisMarker = thisMarker;
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            ArrayList<IMarker> markerList = new ArrayList<IMarker>(markers.length);
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                try {
                    if (marker != this.thisMarker && marker.getType().equals("org.codehaus.groovy.eclipse.core.compilerMismatch")) {
                        markerList.add(marker);
                    }
                }
                catch (CoreException e) {
                    GroovyCore.logException((String)"Error accessing marker", (Throwable)e);
                }
                ++n2;
            }
            return markerList.toArray(new IMarker[0]);
        }
    }

    private static class ConfigureCompilerLevelResolution
    extends AbstractCompilerConfigurator {
        ConfigureCompilerLevelResolution(IMarker thisMarker) {
            super(thisMarker);
        }

        public String getLabel() {
            return "2. Configure Groovy compiler level for project";
        }

        public void run(IMarker marker) {
            IProject project = marker.getResource().getProject();
            PreferenceDialog propertyDialog = PreferencesUtil.createPropertyDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IAdaptable)project, (String)"org.codehaus.groovy.eclipse.preferences.compiler.project", (String[])new String[]{"org.codehaus.groovy.eclipse.preferences.compiler.project"}, null);
            propertyDialog.open();
        }

        public String getDescription() {
            return "Opens the Groovy Compiler preferences for the project so that the compiler level can be changed.";
        }

        public Image getImage() {
            return JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH.createImage();
        }
    }

    private static class ConfigureWorksaceCompilerLevelResolution
    extends AbstractCompilerConfigurator {
        ConfigureWorksaceCompilerLevelResolution(IMarker thisMarker) {
            super(thisMarker);
        }

        public String getLabel() {
            return "3. Configure the Groovy compiler level for the entire workspace";
        }

        public void run(IMarker marker) {
            PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.codehaus.groovy.eclipse.preferences.compiler", (String[])new String[]{"org.codehaus.groovy.eclipse.preferences.compiler"}, null);
            preferenceDialog.open();
        }

        public String getDescription() {
            return "Opens the Groovy Compiler preferences for the workspace preferences.  From here, you can choose the Groovy compiler level for the workspace (restart required).";
        }

        public Image getImage() {
            return JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH.createImage();
        }
    }

    private static class SetToWorkspaceCompilerLevelResolution
    extends AbstractCompilerConfigurator {
        SetToWorkspaceCompilerLevelResolution(IMarker thisMarker) {
            super(thisMarker);
        }

        public String getLabel() {
            return "1. Set the Groovy compiler level for project to match the workspace level";
        }

        public void run(IMarker marker) {
            IProject project = marker.getResource().getProject();
            CompilerUtils.setCompilerLevel((IProject)project, (SpecifiedVersion)CompilerUtils.getActiveGroovyVersion(), (boolean)true);
        }

        public String getDescription() {
            return "Forces the workspace Groovy compiler level onto this project.";
        }

        public Image getImage() {
            return JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH.createImage();
        }
    }
}

