/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.debug.ui.BreakpointLocationFinder;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class BreakpointUpdater
implements IMarkerUpdater {
    public String[] getAttribute() {
        return new String[]{"lineNumber"};
    }

    public String getMarkerType() {
        return "org.eclipse.debug.core.breakpointMarker";
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        block7: {
            ASTNode node;
            IBreakpoint breakpoint;
            block8: {
                GroovyCompilationUnit unit = this.getCompilationUnit(marker);
                if (unit == null) {
                    return true;
                }
                if (position.isDeleted()) {
                    return false;
                }
                IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                breakpoint = manager.getBreakpoint(marker);
                if (breakpoint == null) {
                    return false;
                }
                Object attribute = marker.getAttribute("lineNumber");
                if (attribute == null) break block7;
                node = new BreakpointLocationFinder(unit.getModuleNode()).findBreakpointLocation((Integer)attribute);
                if (node != null) break block8;
                return false;
            }
            try {
                int line = node.getLineNumber();
                MarkerUtilities.setLineNumber((IMarker)marker, (int)line);
                if (!this.isLineBreakpoint(marker)) break block7;
                this.ensureRanges(document, marker, line);
                return this.lineBreakpointExists(marker.getResource(), ((IJavaLineBreakpoint)breakpoint).getTypeName(), line, marker) == null;
            }
            catch (CoreException e) {
                GroovyCore.logException((String)"Error updating breakpoint", (Throwable)e);
                return false;
            }
            catch (BadLocationException e) {
                GroovyCore.logException((String)"Error updating breakpoint", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private GroovyCompilationUnit getCompilationUnit(IMarker marker) {
        IResource resource = marker.getResource();
        if (!Util.isJavaLikeFileName((String)resource.getName())) {
            return null;
        }
        ICompilationUnit unit = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getWorkingCopy((Object)resource);
        if (unit == null && resource.getType() == 1) {
            unit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource));
        }
        if (unit != null && unit instanceof GroovyCompilationUnit) {
            return (GroovyCompilationUnit)unit;
        }
        return null;
    }

    private void ensureRanges(IDocument document, IMarker marker, int line) throws BadLocationException {
        if (line < 0 || line > document.getNumberOfLines()) {
            return;
        }
        IRegion region = document.getLineInformation(line - 1);
        int charstart = region.getOffset();
        int charend = charstart + region.getLength();
        MarkerUtilities.setCharStart((IMarker)marker, (int)charstart);
        MarkerUtilities.setCharEnd((IMarker)marker, (int)charend);
    }

    private boolean isLineBreakpoint(IMarker marker) {
        return MarkerUtilities.isMarkerType((IMarker)marker, (String)"org.eclipse.jdt.debug.javaLineBreakpointMarker");
    }

    private IJavaLineBreakpoint lineBreakpointExists(IResource resource, String typeName, int lineNumber, IMarker currentmarker) throws CoreException {
        String modelId = JDIDebugPlugin.getUniqueIdentifier();
        String markerType = JavaLineBreakpoint.getMarkerType();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            String breakpointTypeName;
            IJavaLineBreakpoint breakpoint;
            IMarker marker;
            if (breakpoints[i] instanceof IJavaLineBreakpoint && (marker = (breakpoint = (IJavaLineBreakpoint)breakpoints[i]).getMarker()) != null && marker.exists() && marker.getType().equals(markerType) && currentmarker.getId() != marker.getId() && ((breakpointTypeName = breakpoint.getTypeName()).equals(typeName) || breakpointTypeName.startsWith(typeName + "$")) && breakpoint.getLineNumber() == lineNumber && resource.equals((Object)marker.getResource())) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }
}

