/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug.ui;

import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.debug.ui.GroovyBreakpointRulerAction;
import org.codehaus.jdt.groovy.model.GroovyNature;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.debug.ui.actions.RulerToggleBreakpointActionDelegate;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class GroovyBreakpointRulerActionDelegate
extends RulerToggleBreakpointActionDelegate {
    private GroovyBreakpointRulerAction delegate;

    protected IAction createAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        IProject project = this.getProject(editor.getEditorInput());
        if (project != null && GroovyNature.hasGroovyNature((IProject)project) && this.hasGroovySource(editor)) {
            this.delegate = new GroovyBreakpointRulerAction(rulerInfo, editor, this.getEditorPart());
            return this.delegate;
        }
        return super.createAction(editor, rulerInfo);
    }

    public void runWithEvent(IAction action, Event event) {
        if (this.delegate != null) {
            this.delegate.runWithEvent(event);
        } else {
            super.runWithEvent(action, event);
        }
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
            this.delegate = null;
        }
        super.dispose();
    }

    protected IEditorPart getEditorPart() {
        return (IEditorPart)ReflectionUtils.getPrivateField(RulerToggleBreakpointActionDelegate.class, (String)"fEditor", (Object)((Object)this));
    }

    protected IProject getProject(IEditorInput editorInput) {
        IFile file = (IFile)Adapters.adapt((Object)editorInput, IFile.class);
        if (file != null) {
            return file.getProject();
        }
        IClassFile classFile = (IClassFile)Adapters.adapt((Object)editorInput, IClassFile.class);
        if (classFile != null) {
            return classFile.getJavaProject().getProject();
        }
        return null;
    }

    protected boolean hasGroovySource(ITextEditor editor) {
        return Adapters.adapt((Object)editor, ModuleNode.class) != null;
    }
}

