/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.osgi.framework.Version;

public class CompilerSwitchUIHelper {
    static final String PROP_VM = "eclipse.vm";
    static final String PROP_VMARGS = "eclipse.vmargs";
    static final String PROP_REFRESH_BUNDLES = "-Declipse.refreshBundles=true";
    static final String PROP_CLEAN = "-Dosgi.clean=true";
    static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    static final String CMD_VMARGS = "-vmargs";
    static final String NEW_LINE = "\n";

    public static Composite createCompilerSwitchBlock(Composite parent) {
        Composite compilerPage = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        compilerPage.setLayout((Layout)layout);
        SpecifiedVersion activeGroovyVersion = CompilerUtils.getActiveGroovyVersion();
        Label compilerVersion = new Label(compilerPage, 16448);
        compilerVersion.setText("You are currently using Groovy Compiler version " + CompilerUtils.getGroovyVersion() + ".");
        SpecifiedVersion[] specifiedVersionArray = SpecifiedVersion.values();
        int n = specifiedVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpecifiedVersion version = specifiedVersionArray[n2];
            if (activeGroovyVersion != version) {
                CompilerSwitchUIHelper.switchVersion(version, compilerPage);
            }
            ++n2;
        }
        Link moreInfoLink = new Link(compilerPage, 0);
        moreInfoLink.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        moreInfoLink.setText("<a href=\"https://github.com/groovy/groovy-eclipse/wiki\">See here</a> for more information (opens a browser window).");
        moreInfoLink.addListener(13, event -> CompilerSwitchUIHelper.openUrl(event.text));
        return compilerPage;
    }

    private static void switchVersion(final SpecifiedVersion toSpecifiedVersion, final Composite compilerPage) {
        final Version toVersion = CompilerUtils.getBundleVersion((SpecifiedVersion)toSpecifiedVersion);
        if (toVersion == null) {
            return;
        }
        Button switchTo = new Button(compilerPage, 8);
        switchTo.setText("Switch to " + String.valueOf(toVersion));
        switchTo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = compilerPage.getShell();
                boolean result = MessageDialog.openQuestion((Shell)shell, (String)"Change compiler and restart?", (String)"Do you want to change the compiler?\n\nIf you select \"Yes\", the compiler will be changed and Eclipse will be restarted.\n\nMake sure all your work is saved before clicking \"Yes\".");
                if (result) {
                    SpecifiedVersion activeGroovyVersion = CompilerUtils.getActiveGroovyVersion();
                    IStatus status = CompilerUtils.switchVersions((SpecifiedVersion)activeGroovyVersion, (SpecifiedVersion)toSpecifiedVersion);
                    if (status == Status.OK_STATUS) {
                        CompilerSwitchUIHelper.restart(shell);
                    } else {
                        ErrorDialog error = new ErrorDialog(shell, "Error occurred", "Error occurred when trying to enable Groovy " + String.valueOf(toVersion), status, 4);
                        error.open();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected static void restart(Shell shell) {
        String commandLine = CompilerSwitchUIHelper.buildCommandLine(shell);
        if (commandLine == null) {
            return;
        }
        System.out.println("Restart command line begin:\n " + commandLine);
        System.out.println("Restart command line end");
        System.setProperty(PROP_EXIT_DATA, commandLine);
        System.setProperty(PROP_EXIT_CODE, Integer.toString(24));
        Workbench.getInstance().restart();
    }

    private static String buildCommandLine(Shell shell) {
        String property = System.getProperty(PROP_VM);
        if (property == null) {
            MessageDialog.openError((Shell)shell, (String)"Missing System Property", (String)NLS.bind((String)"Unable to relaunch the platform because the {0} property has not been set.", (Object)PROP_VM));
            return null;
        }
        StringBuffer result = new StringBuffer(512);
        result.append(property);
        result.append(NEW_LINE);
        Object vmargs = System.getProperty(PROP_VMARGS, "");
        vmargs = (String)vmargs + "\n-Declipse.refreshBundles=true\n-Dosgi.clean=true\n";
        result.append((String)vmargs);
        property = System.getProperty(PROP_COMMANDS);
        if (property != null) {
            result.append(property);
        }
        if (vmargs != null) {
            result.append(CMD_VMARGS);
            result.append(NEW_LINE);
            result.append((String)vmargs);
        }
        return result.toString();
    }

    public static void openUrl(String location) {
        try {
            URL url = null;
            if (location != null) {
                url = new URL(location);
            }
            if (WebBrowserPreference.getBrowserChoice() == 1) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(url);
                }
                catch (Exception e) {
                    GroovyCore.logException((String)"Could not open browser", (Throwable)e);
                }
            } else {
                IWebBrowser browser = null;
                int flags = 0;
                flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? (flags |= 0x26) : (flags |= 0x86);
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, "org.eclipse.contribution.weaving.jdt", null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Browser initialization error", (String)"Browser could not be initiated");
        }
        catch (MalformedURLException e) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Malformed URL", (String)location);
        }
    }
}

