/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.refactoring.actions.GroovyImportsCleanUp;
import org.codehaus.groovy.eclipse.refactoring.actions.OrganizeGroovyImports;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.CleanUpAction;
import org.eclipse.jdt.internal.ui.actions.MultiOrganizeImportAction;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class OrganizeGroovyImportsAction
extends OrganizeImportsAction {
    public OrganizeGroovyImportsAction(IWorkbenchPartSite site) {
        super((IWorkbenchSite)site);
    }

    public OrganizeGroovyImportsAction(JavaEditor editor) {
        super(editor);
    }

    public void run(ICompilationUnit unit) {
        if (!(unit instanceof GroovyCompilationUnit)) {
            super.run(unit);
        } else {
            try {
                IStatusLineManager manager;
                JavaEditor editor = this.getEditor();
                if (editor == null) {
                    IEditorPart openEditor = EditorUtility.isOpenInEditor((Object)unit);
                    if (!(openEditor instanceof JavaEditor)) {
                        this.getDelegate().run((IStructuredSelection)new StructuredSelection((Object)unit));
                        return;
                    }
                    editor = (JavaEditor)openEditor;
                }
                if (!ElementValidator.check((IJavaElement)unit, (Shell)this.getShell(), (String)ActionMessages.OrganizeImportsAction_error_title, (boolean)false)) {
                    return;
                }
                OrganizeGroovyImports action = new OrganizeGroovyImports((GroovyCompilationUnit)unit, this.newChooseImportQuery(editor));
                boolean success = action.calculateAndApplyMissingImports();
                if (!success && (manager = editor.getEditorSite().getActionBars().getStatusLineManager()) != null) {
                    manager.setMessage(ActionMessages.bind((String)ActionMessages.OrganizeImportsAction_multi_error_parse, (Object)BasicElementLabels.getPathLabel((IPath)unit.getPath(), (boolean)false)));
                }
            }
            catch (Exception e) {
                GroovyPlugin.getDefault().logError("Error organizing imports for " + unit.getElementName(), e);
            }
        }
    }

    public void run(IStructuredSelection selection) {
        MultiOrganizeImportAction delegate = this.getDelegate();
        ICompilationUnit[] units = delegate.getCompilationUnits(selection);
        if (units.length <= 1) {
            super.run(selection);
        } else {
            ReflectionUtils.executePrivateMethod(CleanUpAction.class, (String)"runOnMultiple", (Class[])new Class[]{ICompilationUnit[].class}, (Object)delegate, (Object[])new Object[]{units});
        }
    }

    protected JavaEditor getEditor() {
        return (JavaEditor)ReflectionUtils.getPrivateField(OrganizeImportsAction.class, (String)"fEditor", (Object)((Object)this));
    }

    protected MultiOrganizeImportAction getDelegate() {
        MultiOrganizeImportAction delegate = (MultiOrganizeImportAction)ReflectionUtils.getPrivateField(OrganizeImportsAction.class, (String)"fCleanUpDelegate", (Object)((Object)this));
        MultiOrganizeImportAction override = new MultiOrganizeImportAction(this.getSite()){

            protected ICleanUp[] getCleanUps(ICompilationUnit[] units) {
                return new ICleanUp[]{new GroovyImportsCleanUp()};
            }
        };
        override.setEnabled(delegate.isEnabled());
        return override;
    }

    protected OrganizeGroovyImports.IChooseImportQuery newChooseImportQuery(JavaEditor editor) {
        return (choices, ranges) -> (TypeNameMatch[])ReflectionUtils.executePrivateMethod(OrganizeImportsAction.class, (String)"doChooseImports", (Class[])new Class[]{TypeNameMatch[][].class, ISourceRange[].class, JavaEditor.class}, (Object)((Object)this), (Object[])new Object[]{choices, ranges, editor});
    }
}

