/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.search;

import java.util.Collections;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.CodeSelectHelper;
import org.codehaus.groovy.eclipse.core.search.FindAllReferencesRequestor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.internal.core.manipulation.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.FindOccurrencesEngine;

public class GroovyOccurrencesFinder
implements IOccurrencesFinder {
    private AnnotatedNode nodeToLookFor;
    private GroovyCompilationUnit gunit;
    private CompilationUnit cunit;
    private String elementName;

    public String getElementName() {
        if (this.elementName == null) {
            if (this.nodeToLookFor instanceof ClassNode) {
                String name = ((ClassNode)this.nodeToLookFor).getNameWithoutPackage();
                int lastDollar = name.lastIndexOf(36);
                this.elementName = name.substring(lastDollar + 1);
            } else if (this.nodeToLookFor instanceof MethodNode) {
                this.elementName = ((MethodNode)this.nodeToLookFor).getName();
            } else if (this.nodeToLookFor instanceof FieldNode) {
                this.elementName = ((FieldNode)this.nodeToLookFor).getName();
            } else if (this.nodeToLookFor instanceof Variable) {
                this.elementName = ((Variable)this.nodeToLookFor).getName();
            }
        }
        return this.elementName;
    }

    public org.codehaus.groovy.ast.ASTNode getNodeToLookFor() {
        return this.nodeToLookFor;
    }

    public CompilationUnit getASTRoot() {
        return this.cunit;
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        Map<org.codehaus.groovy.ast.ASTNode, Integer> occurences = this.internalFindOccurences();
        IOccurrencesFinder.OccurrenceLocation[] locations = new IOccurrencesFinder.OccurrenceLocation[occurences.size()];
        int i = 0;
        for (Map.Entry<org.codehaus.groovy.ast.ASTNode, Integer> entry : occurences.entrySet()) {
            IOccurrencesFinder.OccurrenceLocation occurrenceLocation;
            org.codehaus.groovy.ast.ASTNode node = entry.getKey();
            int flags = entry.getValue();
            if (node instanceof ClassNode && ((ClassNode)node).getNameEnd() > 0 || node instanceof Parameter || node instanceof FieldNode || node instanceof MethodNode || node instanceof StaticMethodCallExpression) {
                AnnotatedNode n = (AnnotatedNode)node;
                occurrenceLocation = new IOccurrencesFinder.OccurrenceLocation(n.getNameStart(), n.getNameEnd() - n.getNameStart() + 1, flags, "Occurrence of ''" + this.getElementName() + "''");
            } else {
                SourceRange r = this.getSourceRange(node);
                occurrenceLocation = new IOccurrencesFinder.OccurrenceLocation(r.getOffset(), r.getLength(), flags, "Occurrence of ''" + this.getElementName() + "''");
            }
            locations[i++] = occurrenceLocation;
        }
        return locations;
    }

    private SourceRange getSourceRange(org.codehaus.groovy.ast.ASTNode node) {
        int simpleNameStart;
        String name;
        String semiQualifiedName;
        if (node instanceof ConstructorCallExpression) {
            node = ((ConstructorCallExpression)node).getType();
        }
        if (node instanceof ClassNode && (semiQualifiedName = ((ClassNode)node).getNameWithoutPackage()).contains("$") && (name = this.getElementName()).length() < node.getLength() - 1 && (simpleNameStart = semiQualifiedName.indexOf(name)) >= 0) {
            return new SourceRange(node.getStart() + simpleNameStart, name.length());
        }
        return new SourceRange(node.getStart(), node.getLength());
    }

    private Map<org.codehaus.groovy.ast.ASTNode, Integer> internalFindOccurences() {
        if (!(this.nodeToLookFor == null || this.nodeToLookFor instanceof ConstantExpression || this.nodeToLookFor instanceof ClosureExpression || this.nodeToLookFor instanceof DeclarationExpression || this.nodeToLookFor instanceof BinaryExpression || this.nodeToLookFor instanceof MethodCallExpression)) {
            FindAllReferencesRequestor requestor = new FindAllReferencesRequestor(this.nodeToLookFor);
            TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(this.gunit);
            visitor.visitCompilationUnit((ITypeRequestor)requestor);
            Map occurences = requestor.getReferences();
            return occurences;
        }
        return Collections.emptyMap();
    }

    public String initialize(CompilationUnit root, int offset, int length) {
        ModuleNode moduleNode;
        this.cunit = root;
        if (this.gunit == null) {
            ITypeRoot typeRoot = this.cunit.getTypeRoot();
            if (!(typeRoot instanceof GroovyCompilationUnit)) {
                return "Can't find occurrenes...not a Groovy file.";
            }
            this.gunit = (GroovyCompilationUnit)typeRoot;
        }
        if ((moduleNode = this.gunit.getModuleNode()) == null) {
            return "Can't find occurrences...no module node.";
        }
        CodeSelectHelper helper = new CodeSelectHelper();
        org.codehaus.groovy.ast.ASTNode node = helper.selectASTNode(this.gunit, offset, length);
        if (!(node instanceof AnnotatedNode)) {
            return "Can't find occurrences...invalid selection";
        }
        if (node instanceof PropertyNode) {
            PropertyNode property = (PropertyNode)node;
            node = property.getField();
        }
        this.nodeToLookFor = (AnnotatedNode)node;
        return null;
    }

    public String initialize(CompilationUnit root, ASTNode node) {
        return this.initialize(root, node.getStartPosition(), node.getLength());
    }

    public final void setGroovyCompilationUnit(GroovyCompilationUnit gunit) {
        this.gunit = gunit;
    }

    public static IOccurrencesFinder.OccurrenceLocation[] findOccurrences(CompilationUnit cunit, int offset, int length) {
        GroovyOccurrencesFinder finder = new GroovyOccurrencesFinder();
        finder.initialize(cunit, offset, length);
        return finder.getOccurrences();
    }

    public static FindOccurrencesEngine newFinderEngine() {
        return FindOccurrencesEngine.create((IOccurrencesFinder)new GroovyOccurrencesFinder());
    }

    public String getID() {
        return "GroovyOccurrencesFinder";
    }

    public String getJobLabel() {
        return "Search for Occurrences in File (Groovy)";
    }

    public int getSearchKind() {
        return 5;
    }

    public String getUnformattedSingularLabel() {
        return "''{0}'' - 1 occurrence in ''{1}''";
    }

    public String getUnformattedPluralLabel() {
        return "''{0}'' - {1} occurrences in ''{2}''";
    }
}

