/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map.fill;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.MarkerItemData;
import net.sf.jasperreports.components.map.fill.FillItemData;
import net.sf.jasperreports.components.map.fill.FillLegendItem;
import net.sf.jasperreports.components.map.fill.FillMarkerItemData;
import net.sf.jasperreports.components.map.fill.FillPlaceItemData;
import net.sf.jasperreports.components.map.fill.FillResetMapItem;
import net.sf.jasperreports.components.map.fill.FillStyleItemData;
import net.sf.jasperreports.components.map.type.MapImageTypeEnum;
import net.sf.jasperreports.components.map.type.MapScaleEnum;
import net.sf.jasperreports.components.map.type.MapTypeEnum;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.component.FillContextProvider;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRLoader;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MapFillComponent
extends BaseFillComponent
implements FillContextProvider {
    public static final String PLACE_URL_PREFIX = "https://maps.googleapis.com/maps/api/geocode/xml?address=";
    public static final String PLACE_URL_SUFFIX = "&output=xml&oe=utf8";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String STATUS_NODE = "/GeocodeResponse/status";
    public static final String LATITUDE_NODE = "/GeocodeResponse/result/geometry/location/lat";
    public static final String LONGITUDE_NODE = "/GeocodeResponse/result/geometry/location/lng";
    public static final String STATUS_OK = "OK";
    public static final String EXCEPTION_MESSAGE_KEY_NULL_OR_EMPTY_VALUE_NOT_ALLOWED = "components.map.null.or.empty.value.not.allowed";
    public static final String EXCEPTION_MESSAGE_KEY_NULL_OR_EMPTY_VALUES_NOT_ALLOWED = "components.map.null.or.empty.values.not.allowed";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_ADDRESS_COORDINATES = "components.map.invalid.address.coordinates";
    public static final String EXCEPTION_MESSAGE_KEY_ADDRESS_REQUEST_FAILED = "components.map.address.request.failed";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_POSITION_VALUE = "components.map.custom.control.position.invalid.value";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_ORIENTATION_VALUE = "components.map.custom.control.orientation.invalid.value";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_LEGEND_PROPERTY_VALUE = "components.map.legend.invalid.value";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_LEGEND_SIZE_PROPERTY_VALUE = "components.map.legend.invalid.size.value";
    private final MapComponent mapComponent;
    private Float latitude;
    private Float longitude;
    private String center;
    private Integer zoom;
    private String language;
    private MapTypeEnum mapType;
    private MapScaleEnum mapScale;
    private MapImageTypeEnum imageType;
    private OnErrorTypeEnum onErrorType;
    private Boolean markerClustering;
    private Boolean markerSpidering;
    private String clientId;
    private String signature;
    private String key;
    private String googleVersion;
    private String version;
    private String reqParams;
    private String defaultMarkerIcon;
    private List<FillMarkerItemData> markerDataList;
    private FillLegendItem legend;
    private FillResetMapItem resetMap;
    private List<FillItemData> pathStyleList;
    private List<FillItemData> pathDataList;
    private Map<String, Object> markerSeries;
    private Map<String, Object> legendProperties;
    private Map<String, Object> resetMapProperties;
    private Map<String, Map<String, Object>> styles;
    private List<Map<String, Object>> paths;
    JRFillObjectFactory factory;

    public MapFillComponent(MapComponent map) {
        this.mapComponent = map;
    }

    public MapFillComponent(MapComponent map, JRFillObjectFactory factory) {
        this.mapComponent = map;
        this.factory = factory;
        this.reqParams = this.getReqParams();
        if (this.mapComponent.getLegendItem() != null) {
            this.legend = new FillLegendItem(this, this.mapComponent.getLegendItem(), factory);
        }
        if (this.mapComponent.getResetMapItem() != null) {
            this.resetMap = new FillResetMapItem(this, this.mapComponent.getResetMapItem(), factory);
        }
        if (this.mapComponent.getMarkerDataList() != null) {
            this.markerDataList = new ArrayList<FillMarkerItemData>();
            for (MarkerItemData markerData : this.mapComponent.getMarkerItemDataList()) {
                this.markerDataList.add(new FillMarkerItemData((FillContextProvider)this, markerData, factory));
            }
        }
        if (this.mapComponent.getPathStyleList() != null) {
            this.pathStyleList = new ArrayList<FillItemData>();
            for (ItemData pathStyle : this.mapComponent.getPathStyleList()) {
                this.pathStyleList.add(new FillStyleItemData(this, pathStyle, factory));
            }
        }
        if (this.mapComponent.getPathDataList() != null) {
            this.pathDataList = new ArrayList<FillItemData>();
            for (ItemData pathData : this.mapComponent.getPathDataList()) {
                this.pathDataList.add(new FillPlaceItemData(this, pathData, factory));
            }
        }
    }

    protected MapComponent getMap() {
        return this.mapComponent;
    }

    @Override
    public FillContext getFillContext() {
        return this.fillContext;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateMap(evaluation);
        }
    }

    protected void evaluateMap(byte evaluation) throws JRException {
        List<Map<String, Object>> currentItemList;
        String depVersion;
        JRPropertiesHolder propertiesHolder = this.fillContext.getComponentElement().getParentProperties();
        JRPropertiesUtil util = JRPropertiesUtil.getInstance(this.fillContext.getFiller().getJasperReportsContext());
        this.clientId = util.getProperty(propertiesHolder, "net.sf.jasperreports.components.map.client.id");
        this.signature = util.getProperty(propertiesHolder, "net.sf.jasperreports.components.map.signature");
        this.key = util.getProperty(propertiesHolder, "net.sf.jasperreports.components.map.key");
        this.defaultMarkerIcon = util.getProperty(propertiesHolder, "net.sf.jasperreports.components.map.default.marker.icon");
        this.googleVersion = util.getProperty(propertiesHolder, "net.sf.jasperreports.components.map.google.version");
        this.version = depVersion = util.getProperty(propertiesHolder, "net.sf.jasperreports.components.map.version");
        Number lat = (Number)this.fillContext.evaluate(this.mapComponent.getLatitudeExpression(), evaluation);
        this.latitude = lat == null ? null : Float.valueOf(lat.floatValue());
        Number lg = (Number)this.fillContext.evaluate(this.mapComponent.getLongitudeExpression(), evaluation);
        this.longitude = lg == null ? null : Float.valueOf(lg.floatValue());
        this.reqParams = this.getReqParams();
        if (this.latitude == null || this.longitude == null) {
            this.center = (String)this.fillContext.evaluate(this.mapComponent.getAddressExpression(), evaluation);
            Float[] coords = this.getCoords(this.center);
            if (coords != null && coords[0] != null && coords[1] != null) {
                this.latitude = coords[0];
                this.longitude = coords[1];
            } else {
                throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_ADDRESS_COORDINATES, "latitude", "longitude");
            }
        }
        this.zoom = (Integer)this.fillContext.evaluate(this.mapComponent.getZoomExpression(), evaluation);
        Integer n = this.zoom = this.zoom == null ? MapComponent.DEFAULT_ZOOM : this.zoom;
        if (this.mapComponent.getLanguageExpression() != null) {
            this.language = (String)this.fillContext.evaluate(this.mapComponent.getLanguageExpression(), evaluation);
        } else {
            Locale locale = this.fillContext.getReportLocale();
            if (locale != null) {
                this.language = locale.getLanguage();
            }
        }
        this.mapType = this.mapComponent.getMapType() == null ? MapTypeEnum.ROADMAP : this.mapComponent.getMapType();
        this.mapScale = this.mapComponent.getMapScale();
        this.imageType = this.mapComponent.getImageType();
        this.markerClustering = this.mapComponent.getMarkerClustering();
        this.markerSpidering = this.mapComponent.getMarkerSpidering();
        if (this.legend != null) {
            this.legendProperties = this.legend.getEvaluatedItemProperties(evaluation);
        }
        if (this.resetMap != null) {
            this.resetMapProperties = this.resetMap.getEvaluatedItemProperties(evaluation);
        }
        if (this.markerDataList != null) {
            this.markerSeries = new LinkedHashMap<String, Object>();
            int i = 0;
            for (FillMarkerItemData markerData : this.markerDataList) {
                currentItemList = markerData.getEvaluateItems(evaluation);
                if (currentItemList != null && !currentItemList.isEmpty()) {
                    Object legendIcon;
                    Object markerSpidering;
                    LinkedHashMap<String, Object> markerSingleSeriesConfiguration = new LinkedHashMap<String, Object>();
                    Object markerClustering = markerData.getEvaluateMarkerClusteringExpression(evaluation);
                    if (markerClustering != null) {
                        markerSingleSeriesConfiguration.put("markerClustering", markerClustering);
                    }
                    if ((markerSpidering = markerData.getEvaluateMarkerSpideringExpression(evaluation)) != null) {
                        markerSingleSeriesConfiguration.put("markerSpidering", markerSpidering);
                    }
                    if ((legendIcon = markerData.getEvaluateLegendIconExpression(evaluation)) != null) {
                        markerSingleSeriesConfiguration.put("legendIcon", legendIcon);
                    }
                    ArrayList<Map<String, Object>> markerSeriesItems = new ArrayList<Map<String, Object>>();
                    for (Map<String, Object> currentItem : currentItemList) {
                        if (currentItem == null) continue;
                        markerSeriesItems.add(currentItem);
                    }
                    markerSingleSeriesConfiguration.put("markers", markerSeriesItems);
                    Object seriesName = markerData.getEvaluateSeriesNameExpression(evaluation);
                    if (seriesName != null) {
                        this.markerSeries.put(seriesName.toString(), markerSingleSeriesConfiguration);
                    } else {
                        this.markerSeries.put("marker_series_" + i, markerSingleSeriesConfiguration);
                    }
                }
                ++i;
            }
        }
        if (this.pathDataList != null) {
            this.addPathStyles(evaluation);
            this.paths = new ArrayList<Map<String, Object>>();
            HashMap<String, Map<String, Object>> pathIds = new HashMap<String, Map<String, Object>>();
            for (FillItemData pathData : this.pathDataList) {
                currentItemList = pathData.getEvaluateItems(evaluation);
                if (currentItemList == null || currentItemList.isEmpty()) continue;
                for (Map<String, Object> currentItem : currentItemList) {
                    if (currentItem == null) continue;
                    String pathName = currentItem.get("name") != null ? (String)currentItem.get("name") : "DEFAULT_PATH_NAME";
                    Map<String, Object> pathMap = null;
                    if (pathIds.containsKey(pathName)) {
                        pathMap = (Map)pathIds.get(pathName);
                    } else {
                        pathMap = new HashMap();
                        pathMap.put("locations", new ArrayList());
                        pathIds.put(pathName, pathMap);
                        this.paths.add(pathMap);
                    }
                    this.setStyle((String)currentItem.get("style"), pathMap);
                    boolean coordSet = false;
                    for (String key : currentItem.keySet()) {
                        if ("name".equals(key) || "style".equals(key)) continue;
                        if ("latitude".equals(key) || "longitude".equals(key)) {
                            if (coordSet) continue;
                            if (currentItem.get("latitude") == null || currentItem.get("longitude") == null) {
                                throw new JRException(EXCEPTION_MESSAGE_KEY_NULL_OR_EMPTY_VALUES_NOT_ALLOWED, "latitude", "longitude");
                            }
                            HashMap<String, Object> location = new HashMap<String, Object>();
                            location.put("latitude", currentItem.get("latitude"));
                            location.put("longitude", currentItem.get("longitude"));
                            ((List)pathMap.get("locations")).add(location);
                            coordSet = true;
                            continue;
                        }
                        pathMap.put(key, currentItem.get(key));
                    }
                }
            }
        }
        this.onErrorType = this.mapComponent.getOnErrorType();
    }

    protected void addPathStyles(byte evaluation) throws JRException {
        this.styles = new HashMap<String, Map<String, Object>>();
        if (this.pathStyleList != null) {
            for (FillItemData styleData : this.pathStyleList) {
                List<Map<String, Object>> currentStyleList = styleData.getEvaluateItems(evaluation);
                if (currentStyleList == null || currentStyleList.isEmpty()) continue;
                for (Map<String, Object> currentStyle : currentStyleList) {
                    String styleName = (String)currentStyle.get("name");
                    if (styleName == null) {
                        throw new JRException(EXCEPTION_MESSAGE_KEY_NULL_OR_EMPTY_VALUE_NOT_ALLOWED, "name");
                    }
                    HashMap<String, Object> styleMap = null;
                    if (this.styles.containsKey(styleName)) {
                        styleMap = this.styles.get(styleName);
                    } else {
                        styleMap = new HashMap();
                        this.styles.put(styleName, styleMap);
                    }
                    this.setStyle(currentStyle, styleMap);
                }
            }
        }
    }

    protected void setStyle(String styleName, Map<String, Object> styleMap) {
        Map<String, Object> parentStyleMap;
        if (styleName != null && (parentStyleMap = this.styles.get(styleName)) != null && !parentStyleMap.isEmpty()) {
            String parentStyleName = (String)parentStyleMap.get("style");
            if (parentStyleName != null) {
                this.setStyle(parentStyleName, styleMap);
            }
            this.setStyle(parentStyleMap, styleMap);
        }
    }

    protected void setStyle(Map<String, Object> parentStyleMap, Map<String, Object> styleMap) {
        if (parentStyleMap != null) {
            for (Map.Entry<String, Object> entry : parentStyleMap.entrySet()) {
                Object styleValue;
                String styleProperty = entry.getKey();
                if ("name".equals(styleProperty) || "latitude".equals(styleProperty) || "longitude".equals(styleProperty) || (styleValue = entry.getValue()) == null || styleValue.toString().length() <= 0) continue;
                styleMap.put(styleProperty, styleValue);
            }
        }
    }

    protected boolean isEvaluateNow() {
        return this.mapComponent.getEvaluationTime() == EvaluationTimeEnum.NOW;
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    @Override
    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateGenericElement template = new JRTemplateGenericElement(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider(), MapComponent.MAP_ELEMENT_TYPE);
        template = this.deduplicate(template);
        JRTemplateGenericPrintElement printElement = new JRTemplateGenericPrintElement(template, this.printElementOriginator);
        printElement.setUUID(element.getUUID());
        printElement.setX(element.getX());
        printElement.setY(this.fillContext.getElementPrintY());
        printElement.setWidth(element.getWidth());
        printElement.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.copy(printElement);
        } else {
            this.fillContext.registerDelayedEvaluation(printElement, this.mapComponent.getEvaluationTime(), this.mapComponent.getEvaluationGroup());
        }
        return printElement;
    }

    @Override
    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateMap(evaluation);
        this.copy((JRGenericPrintElement)element);
    }

    protected void copy(JRGenericPrintElement printElement) {
        printElement.setParameterValue("latitude", this.latitude);
        printElement.setParameterValue("longitude", this.longitude);
        printElement.setParameterValue("zoom", this.zoom);
        String reqParams = this.getReqParams();
        if (reqParams != null && reqParams.trim().length() > 0) {
            printElement.setParameterValue("reqParams", reqParams);
        }
        if (this.defaultMarkerIcon != null && this.defaultMarkerIcon.trim().length() > 0) {
            printElement.setParameterValue("defaultMarkerIcon", this.defaultMarkerIcon);
        }
        if (this.mapType != null) {
            printElement.setParameterValue("mapType", this.mapType.getName());
        }
        if (this.mapScale != null) {
            printElement.setParameterValue("mapScale", this.mapScale.getName());
        }
        if (this.imageType != null) {
            printElement.setParameterValue("imageType", this.imageType.getName());
        }
        if (this.markerClustering != null) {
            printElement.setParameterValue("markerClustering", this.markerClustering);
        }
        if (this.markerSpidering != null) {
            printElement.setParameterValue("markerSpidering", this.markerSpidering);
        }
        if (this.onErrorType != null) {
            printElement.setParameterValue("onErrorType", this.onErrorType.getName());
        }
        if (this.markerSeries != null && !this.markerSeries.isEmpty()) {
            printElement.setParameterValue("markers", this.markerSeries);
        }
        if (this.legendProperties != null && !this.legendProperties.isEmpty()) {
            printElement.setParameterValue("legendProperties", this.legendProperties);
        }
        if (this.resetMapProperties != null && !this.resetMapProperties.isEmpty()) {
            printElement.setParameterValue("resetMapProperties", this.resetMapProperties);
        }
        if (this.paths != null && !this.paths.isEmpty()) {
            printElement.setParameterValue("paths", this.paths);
        }
    }

    public String getReqParams() {
        if (this.reqParams == null) {
            String rParams = "";
            if (this.language != null && this.language.trim().length() > 0) {
                rParams = rParams + "&language=" + this.language;
            }
            if (this.clientId != null && this.clientId.trim().length() > 0) {
                rParams = rParams + "&client=" + this.clientId;
                if (this.signature != null) {
                    rParams = rParams + "&signature=" + this.signature;
                }
            } else if (this.key != null && this.key.trim().length() > 0) {
                rParams = rParams + "&key=" + this.key;
            }
            if (this.googleVersion != null && this.googleVersion.trim().length() > 0) {
                rParams = rParams + "&v=" + this.googleVersion;
            } else if (this.version != null && this.version.trim().length() > 0 && (this.version.indexOf(46) < 0 || this.version.indexOf(".exp") > -1)) {
                rParams = rParams + "&v=" + this.version;
            }
            this.reqParams = rParams.length() == 0 ? null : rParams.substring(1);
        }
        return this.reqParams;
    }

    private Float[] getCoords(String address) throws JRException {
        Float[] coords = null;
        if (address != null) {
            try {
                String reqParams = this.getReqParams();
                reqParams = reqParams != null && reqParams.trim().length() > 0 ? "&" + reqParams : reqParams;
                String urlStr = PLACE_URL_PREFIX + URLEncoder.encode(address, DEFAULT_ENCODING) + reqParams + PLACE_URL_SUFFIX;
                URL url = new URL(urlStr);
                byte[] response = JRLoader.loadBytes(url);
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(response));
                Node statusNode = (Node)new DOMXPath(STATUS_NODE).selectSingleNode((Object)document);
                String status = statusNode.getTextContent();
                if (!STATUS_OK.equals(status)) {
                    throw new JRException(EXCEPTION_MESSAGE_KEY_ADDRESS_REQUEST_FAILED, status);
                }
                coords = new Float[2];
                Node latNode = (Node)new DOMXPath(LATITUDE_NODE).selectSingleNode((Object)document);
                coords[0] = Float.valueOf(latNode.getTextContent());
                Node lngNode = (Node)new DOMXPath(LONGITUDE_NODE).selectSingleNode((Object)document);
                coords[1] = Float.valueOf(lngNode.getTextContent());
            }
            catch (Exception e) {
                throw new JRException(e);
            }
        }
        return coords;
    }
}

