/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.components;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.objectspy.components.CapturedHTMLElementsTreeComposite;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import com.kms.katalon.objectspy.element.HTMLElement;
import com.kms.katalon.objectspy.element.HTMLPageElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;

public class CapturedHTMLElementsComposite
extends Composite {
    private Text elementNameText;
    private Text elementTypeText;
    private TableViewer attributesTableViewer;
    private CapturedHTMLElementsTreeComposite capturedHTMLElementsTreeComposite;
    private HTMLElement selectedElement;

    public CapturedHTMLElementsComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_capturedObjectComposite = new GridLayout();
        gl_capturedObjectComposite.marginBottom = 5;
        gl_capturedObjectComposite.horizontalSpacing = 0;
        gl_capturedObjectComposite.marginWidth = 0;
        gl_capturedObjectComposite.marginHeight = 0;
        this.setLayout((Layout)gl_capturedObjectComposite);
        SashForm vSashForm = new SashForm((Composite)this, 0);
        vSashForm.setSashWidth(5);
        vSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.capturedHTMLElementsTreeComposite = new CapturedHTMLElementsTreeComposite((Composite)vSashForm, 0);
        Composite objectPropertiesComposite = new Composite((Composite)vSashForm, 0);
        objectPropertiesComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
        GridLayout gl_objectPropertiesComposite = new GridLayout(1, false);
        gl_objectPropertiesComposite.marginWidth = 0;
        gl_objectPropertiesComposite.marginHeight = 0;
        gl_objectPropertiesComposite.horizontalSpacing = 0;
        objectPropertiesComposite.setLayout((Layout)gl_objectPropertiesComposite);
        Label lblObjectProperties = new Label(objectPropertiesComposite, 0);
        lblObjectProperties.setFont(this.getFontBold(lblObjectProperties));
        lblObjectProperties.setText(ObjectspyMessageConstants.DIA_LBL_OBJECT_PROPERTIES);
        Label nameLabel = new Label(objectPropertiesComposite, 0);
        nameLabel.setText(ObjectspyMessageConstants.DIA_LBL_OBJECT_NAME);
        this.elementNameText = new Text(objectPropertiesComposite, 2048);
        this.elementNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label typeLabel = new Label(objectPropertiesComposite, 0);
        typeLabel.setText(ObjectspyMessageConstants.DIA_LBL_HTML_TAG);
        this.elementTypeText = new Text(objectPropertiesComposite, 2048);
        this.elementTypeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite attributesTableComposite = new Composite(objectPropertiesComposite, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        attributesTableComposite.setLayout((Layout)tableColumnLayout);
        GridData attributesTableCompositeGridData = new GridData(16384, 0x1000000, true, true, 1, 1);
        attributesTableCompositeGridData.heightHint = 10000;
        attributesTableCompositeGridData.widthHint = 10000;
        attributesTableComposite.setLayoutData((Object)attributesTableCompositeGridData);
        this.attributesTableViewer = new CTableViewer(attributesTableComposite, 68354);
        this.createColumns(this.attributesTableViewer, tableColumnLayout);
        Table table = this.attributesTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        this.attributesTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.attributesTableViewer.setInput(Collections.emptyList());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.attributesTableViewer);
        vSashForm.setOrientation(512);
        vSashForm.setWeights(new int[]{4, 5});
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.getElementTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection treeSelection;
                Object selectedObject;
                if (event.getSelection() instanceof TreeSelection && (selectedObject = (treeSelection = (TreeSelection)event.getSelection()).getFirstElement()) instanceof HTMLElement) {
                    CapturedHTMLElementsComposite.this.selectedElement = (HTMLElement)selectedObject;
                    CapturedHTMLElementsComposite.this.refreshAttributesTable(CapturedHTMLElementsComposite.this.selectedElement);
                }
            }
        });
        this.elementNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CapturedHTMLElementsComposite.this.selectedElement != null) {
                    CapturedHTMLElementsComposite.this.selectedElement.setName(CapturedHTMLElementsComposite.this.elementNameText.getText());
                    CapturedHTMLElementsComposite.this.refreshElementTree(null);
                }
            }
        });
        this.elementTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CapturedHTMLElementsComposite.this.selectedElement != null) {
                    CapturedHTMLElementsComposite.this.selectedElement.setType(CapturedHTMLElementsComposite.this.elementTypeText.getText());
                }
            }
        });
    }

    private Font getFontBold(Label label) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        return boldDescriptor.createFont((Device)label.getDisplay());
    }

    private void createColumns(TableViewer viewer, TableColumnLayout tableColumnLayout) {
        TableViewerColumn keyColumn = new TableViewerColumn(viewer, 0);
        keyColumn.getColumn().setWidth(30);
        keyColumn.getColumn().setText(GlobalStringConstants.NAME);
        keyColumn.setLabelProvider((CellLabelProvider)new TypeCheckedStyleCellLabelProvider<Map.Entry>(0){

            protected Class<Map.Entry> getElementType() {
                return Map.Entry.class;
            }

            protected Image getImage(Map.Entry element) {
                return null;
            }

            protected String getText(Map.Entry element) {
                Map.Entry entry = element;
                if (entry.getKey() != null) {
                    return ((String)entry.getKey()).toString();
                }
                return "";
            }

            protected Rectangle getTextBounds(Rectangle originalBounds) {
                Rectangle textBounds = super.getTextBounds(originalBounds);
                textBounds.x = 5;
                return textBounds;
            }
        });
        TableViewerColumn valueColumn = new TableViewerColumn(viewer, 0);
        valueColumn.getColumn().setWidth(50);
        valueColumn.getColumn().setText(GlobalStringConstants.VALUE);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)element;
                    return this.hasValueChanged(entry) ? ImageManager.getImage((String)"warning_16.png") : null;
                }
                return null;
            }

            private boolean hasValueChanged(Map.Entry<String, String> attribute) {
                Element matchedElement = this.getMatchedElement();
                String attributeKey = attribute.getKey();
                if (matchedElement == null || this.getMatchedStatus().getStatus() != HTMLElement.HTMLStatus.Changed || !matchedElement.hasAttribute(attributeKey)) {
                    return false;
                }
                return ObjectUtils.notEqual((Object)attribute.getValue(), (Object)matchedElement.getAttribute(attributeKey));
            }

            private HTMLElement.MatchedStatus getMatchedStatus() {
                return CapturedHTMLElementsComposite.this.selectedElement.getMatchedStatus();
            }

            private Element getMatchedElement() {
                return this.getMatchedStatus().getMatchedElement();
            }

            public String getText(Object element) {
                Map.Entry entry;
                if (element instanceof Map.Entry && (entry = (Map.Entry)element).getValue() != null) {
                    return ((String)entry.getValue()).toString();
                }
                return GlobalStringConstants.EMPTY;
            }

            public String getToolTipText(Object element) {
                if (element instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)element;
                    return this.hasValueChanged(entry) ? MessageFormat.format(ObjectspyMessageConstants.TABLE_ELEMENT_TIP_VALUE_CHANGED, this.getMatchedElement().getAttribute((String)entry.getKey())) : null;
                }
                return null;
            }
        });
        valueColumn.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof Map.Entry && value instanceof String) {
                    Map.Entry entry = (Map.Entry)element;
                    entry.setValue(String.valueOf(value));
                    CapturedHTMLElementsComposite.this.attributesTableViewer.refresh(element);
                }
            }

            protected Object getValue(Object element) {
                Map.Entry entry;
                if (element instanceof Map.Entry && (entry = (Map.Entry)element).getValue() != null) {
                    return ((String)entry.getValue()).toString();
                }
                return GlobalStringConstants.EMPTY;
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof Map.Entry) {
                    return new TextCellEditor((Composite)CapturedHTMLElementsComposite.this.attributesTableViewer.getTable());
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof Map.Entry;
            }
        });
        tableColumnLayout.setColumnData((Widget)keyColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 70, true));
        tableColumnLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(80, 120, true));
    }

    public void refreshAttributesTable(HTMLElement selectedElement) {
        if (selectedElement != null) {
            this.elementNameText.setText(selectedElement.getName());
            this.elementTypeText.setText(selectedElement.getType());
            this.elementTypeText.setEditable(!(selectedElement instanceof HTMLPageElement));
            this.elementNameText.setEditable(true);
            this.attributesTableViewer.setInput(new ArrayList<Map.Entry<String, String>>(selectedElement.getAttributes().entrySet()));
        } else {
            this.elementNameText.setText(GlobalStringConstants.EMPTY);
            this.elementTypeText.setText(GlobalStringConstants.EMPTY);
            this.elementNameText.setEditable(false);
            this.elementTypeText.setEditable(false);
            this.attributesTableViewer.setInput(Collections.emptyList());
        }
        this.attributesTableViewer.refresh();
    }

    public TreeViewer getElementTreeViewer() {
        return this.capturedHTMLElementsTreeComposite.getElementTreeViewer();
    }

    public void refreshElementTree(Object object) {
        this.capturedHTMLElementsTreeComposite.refreshElementTree(object);
    }

    public void refreshAttributesTable() {
        this.attributesTableViewer.refresh();
    }

    public Text getElementNameText() {
        return this.elementNameText;
    }

    public Text getElementTypeText() {
        return this.elementTypeText;
    }

    public HTMLElement getSelectedElement() {
        return this.selectedElement;
    }
}

