/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.explorer.providers.FolderProvider;
import com.kms.katalon.composer.folder.dialogs.NewFolderDialog;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import com.kms.katalon.objectspy.element.ConflictWebElementWrapper;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.WebParent;
import com.kms.katalon.objectspy.element.tree.CheckboxTreeSelectionHelper;
import com.kms.katalon.objectspy.element.tree.ConflictStatusWebElementLabelProvider;
import com.kms.katalon.objectspy.element.tree.ResolveConflictWebElementTreeContentProvider;
import com.kms.katalon.objectspy.util.WebElementUtils;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class SaveToObjectRepositoryDialog
extends TreeEntitySelectionDialog {
    private int fWidth = 60;
    private int fHeight = 18;
    private TreeViewer treeViewer;
    private boolean isCheckable;
    private TreeViewer htmlElementTreeViewer;
    private FolderEntity rootFolderEntity;
    private FolderTreeEntity rootFolderTreeEntity;
    private List<ConflictWebElementWrapper> wrapConflictStatusPages;
    private ScopedPreferenceStore store;
    private boolean modified;
    private Button btnAddNewObject;
    private Button btnReplaceObject;
    private Button btnMergeObject;
    private Button btnPageAsFolder;
    private StyledText conflictDesciptionLabel;
    private SashForm form;
    private Composite radioGroup;
    private boolean createFolderAsPageNameAllowed;
    private ConflictOptions selectedConflictOptions;
    private ResolveConflictWebElementTreeContentProvider leftTreeContentProvider;
    private CheckboxTreeSelectionHelper checkboxSelectionHelper = null;
    private final int HIGHLIGHTED_LENGTH = "Highlighted".length();
    private int selectedHtmlElementCount = 0;
    private List<WebElementEntity> allConflictedElementEntities = new LinkedList<WebElementEntity>();
    private int duplicatedByHashedAttributes;
    private int duplicatedByObjectsID;

    public SaveToObjectRepositoryDialog(Shell parentShell, boolean isCheckable, List<WebPage> pages, Object[] expandedHTMLElements) {
        super(parentShell, (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new FolderProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter((EntityProvider)new FolderProvider()));
        ArrayList<WebPage> tmpPages = new ArrayList<WebPage>();
        Object[] objectArray = expandedHTMLElements;
        int n = expandedHTMLElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object wp = objectArray[n2];
            if (wp instanceof WebPage) {
                tmpPages.add((WebPage)wp);
            }
            ++n2;
        }
        this.isCheckable = isCheckable;
        this.wrapConflictStatusPages = this.convertToConflictWebPageWrapper(tmpPages);
        this.store = PreferenceStoreManager.getPreferenceStore(((Object)((Object)this)).getClass());
        this.leftTreeContentProvider = new ResolveConflictWebElementTreeContentProvider(true);
        this.setShellStyle(67696);
        this.setTitle(ObjectspyMessageConstants.TITLE_ADD_TO_OBJECT_DIALOG);
        this.setAllowMultiple(false);
        this.refresh();
    }

    private List<ConflictWebElementWrapper> convertToConflictWebPageWrapper(List<WebPage> inputPages) {
        ArrayList<ConflictWebElementWrapper> conflictPages = new ArrayList<ConflictWebElementWrapper>();
        List<WebPage> flatPages = this.flattenWebPages(inputPages);
        for (WebPage webPage : flatPages) {
            ConflictWebElementWrapper parentWrapper = new ConflictWebElementWrapper(webPage, false);
            ArrayList<ConflictWebElementWrapper> childListWrapper = new ArrayList<ConflictWebElementWrapper>();
            for (WebElement webElement : webPage.getChildren()) {
                if (webElement instanceof WebParent) {
                    WebParent webParent = (WebParent)webElement;
                    childListWrapper.addAll(this.conflictWebPageWrapper(webParent, parentWrapper));
                    continue;
                }
                ConflictWebElementWrapper childWrapper = new ConflictWebElementWrapper(webElement, false);
                childWrapper.setParent(parentWrapper);
                childListWrapper.add(childWrapper);
            }
            parentWrapper.setChildren(childListWrapper);
            conflictPages.add(parentWrapper);
        }
        return conflictPages;
    }

    private List<ConflictWebElementWrapper> conflictWebPageWrapper(WebParent webFrame, ConflictWebElementWrapper parent) {
        ArrayList<ConflictWebElementWrapper> conflictPages = new ArrayList<ConflictWebElementWrapper>();
        ConflictWebElementWrapper webFrameWrapper = new ConflictWebElementWrapper(webFrame, false);
        ArrayList<ConflictWebElementWrapper> childListWrapper = new ArrayList<ConflictWebElementWrapper>();
        webFrameWrapper.setParent(parent);
        for (WebElement element : webFrame.getChildren()) {
            if (element instanceof WebParent) {
                WebParent webParent = (WebParent)element;
                childListWrapper.addAll(this.conflictWebPageWrapper(webParent, webFrameWrapper));
                continue;
            }
            ConflictWebElementWrapper childWrapper = new ConflictWebElementWrapper(element, false);
            childWrapper.setParent(webFrameWrapper);
            childListWrapper.add(childWrapper);
        }
        webFrameWrapper.setChildren(childListWrapper);
        conflictPages.add(webFrameWrapper);
        return conflictPages;
    }

    private void refresh() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject != null) {
            try {
                this.rootFolderEntity = FolderController.getInstance().getObjectRepositoryRoot(currentProject);
                this.rootFolderTreeEntity = new FolderTreeEntity(this.rootFolderEntity, null);
                this.setInput(new Object[]{this.rootFolderTreeEntity});
                this.setInitialSelection(this.rootFolderTreeEntity);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MessageDialog.openError((Shell)this.getParentShell(), (String)GlobalStringConstants.ERROR, (String)e.getMessage());
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createMainDialogArea(parent);
        this.form = new SashForm(composite, 256);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftPanel((Composite)this.form);
        this.createRightPanel((Composite)this.form);
        this.createConflictOptionsPanel(composite);
        this.registerConflictOptionsPanelListeners();
        this.updateInput();
        return composite;
    }

    private Composite createMainDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SaveToObjectRepositoryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateInput() {
        this.createFolderAsPageNameAllowed = this.store.getBoolean("objectspy.addToObjectSpyDialog.createFolderAsPageName");
        this.btnPageAsFolder.setSelection(this.createFolderAsPageNameAllowed);
        this.modified = false;
        this.selectedConflictOptions = Enum.valueOf(ConflictOptions.class, this.store.getString("objectspy.conflictObjectDialog.selectedConflictOption"));
        this.btnAddNewObject.setSelection(this.selectedConflictOptions == ConflictOptions.CREATE_NEW_OBJECT);
        this.btnMergeObject.setSelection(this.selectedConflictOptions == ConflictOptions.MERGE_CHANGE_TO_EXISTING_OBJECT);
        this.btnReplaceObject.setSelection(this.selectedConflictOptions == ConflictOptions.REPLACE_EXISTING_OBJECT);
    }

    private void createRightPanel(Composite parent) {
        Composite objectRepositoryComposite = new Composite(parent, 0);
        Label label = new Label(objectRepositoryComposite, 0);
        label.setText(ObjectspyMessageConstants.DIA_LBL_SELECT_A_DESTINATION_FOLDER);
        label.setLayoutData((Object)new GridData(256));
        this.treeViewer = this.createTreeViewer(objectRepositoryComposite);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SaveToObjectRepositoryDialog.this.reloadStatusCheckboxViewTree();
            }
        });
        this.treeViewer.expandToLevel((Object)this.rootFolderTreeEntity, 1);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree treeWidget = this.treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        treeWidget.setEnabled(true);
    }

    private void reloadStatusCheckboxViewTree() {
        CheckboxTreeViewer checkboxViewer = (CheckboxTreeViewer)this.htmlElementTreeViewer;
        Object[] checkedlst = checkboxViewer.getCheckedElements();
        this.checkConflictObjects(this.wrapConflictStatusPages, this.createFolderAsPageNameAllowed);
        this.htmlElementTreeViewer.setInput(this.wrapConflictStatusPages);
        checkboxViewer.setCheckedElements(checkedlst);
        this.htmlElementTreeViewer.expandAll();
    }

    private void createLeftPanel(Composite parent) {
        Composite htmlObjectTreeComposite = new Composite(parent, 0);
        GridLayout glHtmlObjectComposite = new GridLayout();
        glHtmlObjectComposite.marginTop = 5;
        glHtmlObjectComposite.marginBottom = 5;
        glHtmlObjectComposite.horizontalSpacing = 0;
        glHtmlObjectComposite.marginWidth = 0;
        glHtmlObjectComposite.marginHeight = 0;
        htmlObjectTreeComposite.setLayout((Layout)glHtmlObjectComposite);
        this.btnPageAsFolder = new Button(htmlObjectTreeComposite, 32);
        this.btnPageAsFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnPageAsFolder.setText(ObjectspyMessageConstants.DIA_CHCK_BTN_CREATE_FOLDER_AS_PAGE_NAME);
        this.leftTreeContentProvider.setCreatedNewFolderAsPageName(this.store.getBoolean("objectspy.addToObjectSpyDialog.createFolderAsPageName"));
        if (this.isCheckable) {
            this.htmlElementTreeViewer = new CheckboxTreeViewer(htmlObjectTreeComposite, 2050);
            this.checkboxSelectionHelper = CheckboxTreeSelectionHelper.attach((CheckboxTreeViewer)this.htmlElementTreeViewer, this.leftTreeContentProvider);
        } else {
            this.htmlElementTreeViewer = new TreeViewer(htmlObjectTreeComposite, 2050);
        }
        this.htmlElementTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.htmlElementTreeViewer.setContentProvider((IContentProvider)this.leftTreeContentProvider);
        this.htmlElementTreeViewer.setLabelProvider((IBaseLabelProvider)new ConflictStatusWebElementLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.htmlElementTreeViewer, (int)2);
        this.htmlElementTreeViewer.setInput(this.wrapConflictStatusPages);
        this.htmlElementTreeViewer.expandAll();
        if (this.checkboxSelectionHelper != null) {
            this.checkboxSelectionHelper.setCheckAllItems(true);
        }
    }

    private void refreshTreeEntity(Object object) {
        this.treeViewer.getControl().setRedraw(false);
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        if (object == null) {
            this.treeViewer.refresh();
        } else {
            this.treeViewer.refresh(object);
        }
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.treeViewer.setExpandedState(element, true);
            ++n2;
        }
        this.treeViewer.getControl().setRedraw(true);
    }

    private void createConflictOptionsPanel(Composite parent) {
        parent.setBackgroundMode(2);
        this.conflictDesciptionLabel = new StyledText(parent, 0);
        this.conflictDesciptionLabel.setText(ObjectspyMessageConstants.DIA_MSG_RESOLVE_CONFLICT_DES);
        this.conflictDesciptionLabel.setLayoutData((Object)new GridData(256));
        Color red = Display.getCurrent().getSystemColor(3);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = this.HIGHLIGHTED_LENGTH;
        styleRange.foreground = red;
        this.conflictDesciptionLabel.setStyleRange(styleRange);
        this.conflictDesciptionLabel.setBackground(this.conflictDesciptionLabel.getParent().getBackground());
        this.radioGroup = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 20;
        this.radioGroup.setLayout((Layout)gridLayout);
        this.btnMergeObject = new Button(this.radioGroup, 16);
        this.btnMergeObject.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnMergeObject.setText(ObjectspyMessageConstants.DIA_MSG_RADIO_MERGE);
        this.btnAddNewObject = new Button(this.radioGroup, 16);
        this.btnAddNewObject.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnAddNewObject.setText(ObjectspyMessageConstants.DIA_MSG_RADIO_DUPLICATE);
        this.btnReplaceObject = new Button(this.radioGroup, 16);
        this.btnReplaceObject.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnReplaceObject.setText(ObjectspyMessageConstants.DIA_MSG_RADIO_REPLACE);
    }

    private void setConflictOptionPanelEnable(boolean enabled) {
        this.btnMergeObject.setEnabled(enabled);
        this.btnAddNewObject.setEnabled(enabled);
        this.btnReplaceObject.setEnabled(enabled);
        if (!enabled) {
            Color red = Display.getCurrent().getSystemColor(2);
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = this.conflictDesciptionLabel.getText().length();
            styleRange.foreground = red;
            this.conflictDesciptionLabel.setBackground(this.conflictDesciptionLabel.getParent().getBackground());
            this.conflictDesciptionLabel.setStyleRange(styleRange);
        } else {
            Color red = Display.getCurrent().getSystemColor(3);
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = this.HIGHLIGHTED_LENGTH;
            styleRange.foreground = red;
            this.conflictDesciptionLabel.setStyleRange(styleRange);
            this.conflictDesciptionLabel.setBackground(this.conflictDesciptionLabel.getParent().getBackground());
        }
    }

    private void registerConflictOptionsPanelListeners() {
        this.btnPageAsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveToObjectRepositoryDialog.this.createFolderAsPageNameAllowed = SaveToObjectRepositoryDialog.this.btnPageAsFolder.getSelection();
                SaveToObjectRepositoryDialog.this.leftTreeContentProvider.setCreatedNewFolderAsPageName(SaveToObjectRepositoryDialog.this.createFolderAsPageNameAllowed);
                SaveToObjectRepositoryDialog.this.reloadStatusCheckboxViewTree();
                if (SaveToObjectRepositoryDialog.this.createFolderAsPageNameAllowed) {
                    SaveToObjectRepositoryDialog.this.checkboxSelectionHelper.setCheckAllItems(true);
                }
                SaveToObjectRepositoryDialog.this.store.setValue("objectspy.addToObjectSpyDialog.createFolderAsPageName", SaveToObjectRepositoryDialog.this.createFolderAsPageNameAllowed);
                SaveToObjectRepositoryDialog.this.modified = true;
            }
        });
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveToObjectRepositoryDialog.this.btnAddNewObject.setSelection(e.widget == SaveToObjectRepositoryDialog.this.btnAddNewObject);
                SaveToObjectRepositoryDialog.this.btnMergeObject.setSelection(e.widget == SaveToObjectRepositoryDialog.this.btnMergeObject);
                SaveToObjectRepositoryDialog.this.btnReplaceObject.setSelection(e.widget == SaveToObjectRepositoryDialog.this.btnReplaceObject);
                SaveToObjectRepositoryDialog.this.selectedConflictOptions = SaveToObjectRepositoryDialog.this.getSelectedConflictOption();
                SaveToObjectRepositoryDialog.this.store.setValue("objectspy.conflictObjectDialog.selectedConflictOption", SaveToObjectRepositoryDialog.this.selectedConflictOptions.toString());
                SaveToObjectRepositoryDialog.this.modified = true;
            }
        };
        this.btnAddNewObject.addSelectionListener((SelectionListener)selectionListener);
        this.btnReplaceObject.addSelectionListener((SelectionListener)selectionListener);
        this.btnMergeObject.addSelectionListener((SelectionListener)selectionListener);
    }

    private ConflictOptions getSelectedConflictOption() {
        return this.btnAddNewObject.getSelection() ? ConflictOptions.CREATE_NEW_OBJECT : (this.btnMergeObject.getSelection() ? ConflictOptions.MERGE_CHANGE_TO_EXISTING_OBJECT : ConflictOptions.REPLACE_EXISTING_OBJECT);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btnNewFolder = this.createButton(parent, 22, ObjectspyMessageConstants.DIA_BTN_ADD_NEW_FOLDER, false);
        btnNewFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedObject = SaveToObjectRepositoryDialog.this.getFirstResult();
                if (selectedObject == null) {
                    selectedObject = SaveToObjectRepositoryDialog.this.rootFolderTreeEntity;
                }
                try {
                    FolderEntity newEntity;
                    FolderEntity parentFolder = ((FolderTreeEntity)selectedObject).getObject();
                    String suggestedName = FolderController.getInstance().getAvailableFolderName(parentFolder, ObjectspyMessageConstants.NEW_FOLDER_DEFAULT_NAME);
                    NewFolderDialog newFolderDialog = new NewFolderDialog(SaveToObjectRepositoryDialog.this.getParentShell(), parentFolder);
                    newFolderDialog.setName(suggestedName);
                    newFolderDialog.open();
                    if (newFolderDialog.getReturnCode() == 0 && (newEntity = FolderController.getInstance().addNewFolder(parentFolder, newFolderDialog.getName())) != null) {
                        FolderTreeEntity newFolderTreeEntity = TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)newEntity, (FolderEntity)SaveToObjectRepositoryDialog.this.rootFolderEntity);
                        SaveToObjectRepositoryDialog.this.refreshTreeEntity(selectedObject);
                        SaveToObjectRepositoryDialog.this.treeViewer.expandToLevel(selectedObject, 1);
                        SaveToObjectRepositoryDialog.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newFolderTreeEntity));
                    }
                }
                catch (Exception exception) {
                    LoggerSingleton.logError((Throwable)exception);
                    MessageDialog.openError((Shell)SaveToObjectRepositoryDialog.this.getParentShell(), (String)GlobalStringConstants.ERROR, (String)exception.getMessage());
                }
            }
        });
        Button okButton = this.createButton(parent, 55, IDialogConstants.OK_LABEL, false);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.isDisposed()) {
                    return;
                }
                if (!(SaveToObjectRepositoryDialog.this.getFirstResult() instanceof FolderTreeEntity)) {
                    MessageDialog.openWarning((Shell)SaveToObjectRepositoryDialog.this.getParentShell(), (String)GlobalStringConstants.WARN, (String)ObjectspyMessageConstants.DIA_MSG_PLS_SELECT_A_FOLDER);
                    return;
                }
                if (SaveToObjectRepositoryDialog.this.isCheckable) {
                    Object[] checkedHTMLElements;
                    Control tree = ((CheckboxTreeViewer)SaveToObjectRepositoryDialog.this.htmlElementTreeViewer).getControl();
                    Object[] objectArray = checkedHTMLElements = !ControlUtil.isDisposed((Widget)tree) ? ((CheckboxTreeViewer)SaveToObjectRepositoryDialog.this.htmlElementTreeViewer).getCheckedElements() : null;
                    if (checkedHTMLElements == null || checkedHTMLElements.length <= 0) {
                        MessageDialog.openWarning((Shell)SaveToObjectRepositoryDialog.this.getParentShell(), (String)GlobalStringConstants.WARN, (String)ObjectspyMessageConstants.DIA_MSG_PLS_SELECT_ELEMENT);
                        return;
                    }
                    SaveToObjectRepositoryDialog.this.selectedHtmlElementCount = checkedHTMLElements.length;
                    SaveToObjectRepositoryDialog.this.removeUncheckedElements(SaveToObjectRepositoryDialog.this.wrapConflictStatusPages);
                }
                SaveToObjectRepositoryDialog.this.setReturnCode(0);
                SaveToObjectRepositoryDialog.this.close();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private boolean checkConflictObjects(List<ConflictWebElementWrapper> newPages, boolean createFolderAsPageNameAllowed) {
        boolean foundConflict = false;
        for (ConflictWebElementWrapper wrapPage : newPages) {
            boolean isConflict = this.checkConflictElementOnEachWebPage(wrapPage, wrapPage.getChildren(), createFolderAsPageNameAllowed);
            if (!isConflict) continue;
            foundConflict = true;
        }
        this.setConflictOptionPanelEnable(foundConflict);
        return foundConflict;
    }

    private boolean checkConflictElementOnEachWebPage(ConflictWebElementWrapper page, List<ConflictWebElementWrapper> children, boolean createFolderAsPageNameAllowed) {
        boolean foundConflict = false;
        try {
            List allWebElementEntities;
            FolderTreeEntity selectedParentFolder = (FolderTreeEntity)this.getFirstResult();
            if (selectedParentFolder == null) {
                return foundConflict;
            }
            if (createFolderAsPageNameAllowed) {
                parentEntity = FolderController.getInstance().getFolder(selectedParentFolder.getObject().getLocation() + File.separator + StringUtils.trim((String)page.getOriginalWebElement().getName()));
                allWebElementEntities = ObjectRepositoryController.getInstance().getAllDirectChildren(parentEntity);
            } else {
                parentEntity = FolderController.getInstance().getFolder(selectedParentFolder.getObject().getLocation());
                allWebElementEntities = ObjectRepositoryController.getInstance().getAllChildren(parentEntity);
            }
            int duplicatedByHashedAttributes = 0;
            int duplicatedByObjectsID = 0;
            for (ConflictWebElementWrapper webElement : children) {
                if (webElement.getType() == WebElement.WebElementType.PAGE || !(webElement instanceof ConflictWebElementWrapper)) continue;
                ConflictWebElementWrapper wrapElement = webElement;
                WebElement originalWebElement = wrapElement.getOriginalWebElement();
                String fileRelativePath = selectedParentFolder.getObject().getRelativePath() + File.separator;
                fileRelativePath = createFolderAsPageNameAllowed ? fileRelativePath + StringUtils.trim((String)page.getOriginalWebElement().getName()) + File.separator + StringUtils.trim((String)originalWebElement.getName()) : fileRelativePath + StringUtils.trim((String)originalWebElement.getName());
                WebElementEntity hitWebElementEntity = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(fileRelativePath);
                if (hitWebElementEntity != null) {
                    foundConflict = true;
                    wrapElement.setIsConflicted(hitWebElementEntity != null);
                    page.setIsConflicted(hitWebElementEntity != null);
                    ++duplicatedByObjectsID;
                } else {
                    boolean isHashValueMatched = false;
                    originalWebElement.computeHashValue();
                    int originalHash = originalWebElement.getAttributeHashValue();
                    for (Object entity : allWebElementEntities) {
                        WebElementEntity webElementEntity;
                        int entityHash;
                        if (!(entity instanceof WebElementEntity) || originalHash != (entityHash = WebElementUtils.getHashValue(webElementEntity = (WebElementEntity)entity))) continue;
                        if (!this.allConflictedElementEntities.contains(webElementEntity)) {
                            this.allConflictedElementEntities.add(webElementEntity);
                            ++duplicatedByHashedAttributes;
                        }
                        isHashValueMatched = true;
                        foundConflict = true;
                        break;
                    }
                    wrapElement.setIsConflicted(isHashValueMatched);
                    page.setIsConflicted(isHashValueMatched);
                }
                if (!(originalWebElement instanceof WebParent)) continue;
                this.checkConflictElementOnEachWebPage(page, wrapElement.getChildren(), createFolderAsPageNameAllowed);
            }
            this.setDuplicatedByObjectsID(duplicatedByObjectsID);
            this.setDuplicatedByHashedAttributes(duplicatedByHashedAttributes);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getParentShell(), (String)GlobalStringConstants.ERROR, (String)e.getMessage());
        }
        return foundConflict;
    }

    private void updatePreferenceStore() {
        if (this.modified) {
            try {
                this.store.save();
            }
            catch (IOException ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        }
    }

    public boolean close() {
        this.updatePreferenceStore();
        return super.close();
    }

    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    private void removeUncheckedElements(List<ConflictWebElementWrapper> elementList) {
        int i = 0;
        while (i < elementList.size()) {
            ConflictWebElementWrapper childElement = elementList.get(i);
            if (!((CheckboxTreeViewer)this.htmlElementTreeViewer).getChecked((Object)childElement) && !((CheckboxTreeViewer)this.htmlElementTreeViewer).getGrayed((Object)childElement)) {
                if (this.createFolderAsPageNameAllowed || childElement.getType() != WebElement.WebElementType.PAGE) {
                    elementList.remove(i);
                    continue;
                }
            } else if (childElement.getType() == WebElement.WebElementType.FRAME || childElement.getType() == WebElement.WebElementType.PAGE) {
                this.removeUncheckedElements(childElement.getChildren());
            }
            ++i;
        }
    }

    public SaveToObjectRepositoryDialogResult getDialogResult() throws Exception {
        SaveToObjectRepositoryDialogResult dialogResult = new SaveToObjectRepositoryDialogResult(this.createFolderAsPageNameAllowed, this.getClonePages(), (FolderTreeEntity)this.getFirstResult(), this.selectedConflictOptions, this.selectedHtmlElementCount, this.allConflictedElementEntities);
        return dialogResult;
    }

    public FolderTreeEntity getSelectedParentFolderResult() {
        return (FolderTreeEntity)this.getFirstResult();
    }

    public List<ConflictWebElementWrapper> getClonePages() {
        return this.wrapConflictStatusPages.stream().map(page -> page.softClone()).collect(Collectors.toList());
    }

    private List<WebPage> flattenWebPages(List<WebPage> webPages) {
        ArrayList<WebPage> flatPages = new ArrayList<WebPage>();
        for (WebPage webPage : webPages) {
            WebPage fPage = new WebPage(webPage.getName());
            ArrayList<WebElement> flattenChilds = new ArrayList<WebElement>();
            for (WebElement webElement : webPage.getChildren()) {
                flattenChilds.add(webElement);
            }
            fPage.setChildren(flattenChilds);
            flatPages.add(fPage);
        }
        return flatPages;
    }

    public int getDuplicatedByHashedAttributes() {
        return this.duplicatedByHashedAttributes;
    }

    public void setDuplicatedByHashedAttributes(int duplicatedByHashedAttributes) {
        this.duplicatedByHashedAttributes = duplicatedByHashedAttributes;
    }

    public int getDuplicatedByObjectsID() {
        return this.duplicatedByObjectsID;
    }

    public void setDuplicatedByObjectsID(int duplicatedByObjectsID) {
        this.duplicatedByObjectsID = duplicatedByObjectsID;
    }

    public static enum ConflictOptions {
        CREATE_NEW_OBJECT,
        REPLACE_EXISTING_OBJECT,
        MERGE_CHANGE_TO_EXISTING_OBJECT;

    }

    public static class SaveToObjectRepositoryDialogResult {
        private final boolean createFolderAsPageNameAllowed;
        private final List<ConflictWebElementWrapper> allSelectedPages;
        private final FolderTreeEntity selectedParentFolder;
        private ConflictOptions selectedConflictOption;
        private Map<WebElement, FileEntity> entitySavedMap;
        private int selectedHtmlElementCount;
        private List<WebElementEntity> allConflictedElementEntities;

        public SaveToObjectRepositoryDialogResult(boolean createFolderAsPageNameAllowed, List<ConflictWebElementWrapper> selectedPages, FolderTreeEntity selectedParentFolder, ConflictOptions selectedConflictOption, int selectedHtmlElementCount) {
            this.createFolderAsPageNameAllowed = createFolderAsPageNameAllowed;
            this.selectedParentFolder = selectedParentFolder;
            this.allSelectedPages = selectedPages;
            this.selectedConflictOption = selectedConflictOption;
            this.selectedHtmlElementCount = selectedHtmlElementCount;
            this.allConflictedElementEntities = new LinkedList<WebElementEntity>();
            this.entitySavedMap = new HashMap<WebElement, FileEntity>();
        }

        public SaveToObjectRepositoryDialogResult(boolean createFolderAsPageNameAllowed, List<ConflictWebElementWrapper> selectedPages, FolderTreeEntity selectedParentFolder, ConflictOptions selectedConflictOption, int selectedHtmlElementCount, List<WebElementEntity> allConflictedElementEntities) {
            this.createFolderAsPageNameAllowed = createFolderAsPageNameAllowed;
            this.selectedParentFolder = selectedParentFolder;
            this.allSelectedPages = selectedPages;
            this.selectedConflictOption = selectedConflictOption;
            this.selectedHtmlElementCount = selectedHtmlElementCount;
            this.allConflictedElementEntities = allConflictedElementEntities;
            this.entitySavedMap = new HashMap<WebElement, FileEntity>();
        }

        public boolean isCreateFolderAsPageNameAllowed() {
            return this.createFolderAsPageNameAllowed;
        }

        public List<ConflictWebElementWrapper> getAllSelectedPages() {
            return this.allSelectedPages;
        }

        public FolderTreeEntity getSelectedParentFolder() {
            return this.selectedParentFolder;
        }

        public ConflictOptions getSelectedConflictOption() {
            return this.selectedConflictOption;
        }

        public Map<WebElement, FileEntity> getEntitySavedMap() {
            return this.entitySavedMap;
        }

        public int getSelectedHtmlElementCount() {
            return this.selectedHtmlElementCount;
        }

        public List<WebElementEntity> getAllConflictedElementEntities() {
            return this.allConflictedElementEntities;
        }
    }
}

