/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.preferences;

import com.google.gson.Gson;
import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import com.kms.katalon.objectspy.websocket.AddonHotKeyConfig;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ObjectSpyPreferencePage
extends PreferencePageWithHelp {
    private ScopedPreferenceStore preferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.webui.objectspy");
    private Text txtCaptureObject;
    private Button chckPinWindow;
    private AddonHotKeyConfig hotKeyCaptureObject;
    private List<Integer> acceptTableKeycodes;

    public ObjectSpyPreferencePage() {
        this.initAcceptableKeycode();
    }

    private void initAcceptableKeycode() {
        this.acceptTableKeycodes = new ArrayList<Integer>();
        int index = 97;
        while (index <= 122) {
            this.acceptTableKeycodes.add(index);
            ++index;
        }
        this.acceptTableKeycodes.add(96);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout glComposite = new GridLayout(2, false);
        glComposite.horizontalSpacing = 15;
        composite.setLayout((Layout)glComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chckPinWindow = new Button(composite, 32);
        this.chckPinWindow.setText(ObjectspyMessageConstants.PREF_LBL_PIN_OBJECT_SPY_WINDOW);
        this.createHotKeyComposite(composite);
        this.initializeInput();
        this.addControlModifyListeners();
        return composite;
    }

    protected void createHotKeyComposite(Composite composite) {
        Group grpHotKeys = new Group(composite, 0);
        grpHotKeys.setText(ObjectspyMessageConstants.PREF_LBL_HOTKEYS);
        GridLayout glGrpHotKeys = new GridLayout(2, false);
        glGrpHotKeys.horizontalSpacing = 15;
        grpHotKeys.setLayout((Layout)glGrpHotKeys);
        grpHotKeys.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Label lblCaptureObject = new Label((Composite)grpHotKeys, 0);
        lblCaptureObject.setText(ObjectspyMessageConstants.PREF_LBL_CAPTURE_OBJECT);
        this.txtCaptureObject = new Text((Composite)grpHotKeys, 2048);
        this.txtCaptureObject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void addControlModifyListeners() {
        this.txtCaptureObject.addKeyListener((KeyListener)new KeyCaptureAdapter(this.txtCaptureObject, this.hotKeyCaptureObject, this.acceptTableKeycodes, this));
    }

    private void initializeInput() {
        Gson gson = new Gson();
        this.hotKeyCaptureObject = (AddonHotKeyConfig)gson.fromJson(this.preferenceStore.getString("objectspy.hotkey.captureObject"), AddonHotKeyConfig.class);
        this.txtCaptureObject.setText(KeyStroke.getInstance((int)this.hotKeyCaptureObject.getModifiers(), (int)this.hotKeyCaptureObject.getKeyCode()).format());
        this.chckPinWindow.setSelection(this.preferenceStore.getBoolean("objectspy.pinWindow"));
    }

    protected String getDefaultButtonLabel() {
        return "Restore Defaults";
    }

    protected String getApplyButtonLabel() {
        return "Apply";
    }

    public boolean performOk() {
        if (!this.isInitialized()) {
            return true;
        }
        Gson gson = new Gson();
        this.preferenceStore.setValue("objectspy.hotkey.captureObject", gson.toJson((Object)this.hotKeyCaptureObject));
        this.preferenceStore.setValue("objectspy.pinWindow", this.chckPinWindow.getSelection());
        try {
            this.preferenceStore.save();
            return true;
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    protected void performDefaults() {
        if (!this.isInitialized()) {
            return;
        }
        Gson gson = new Gson();
        this.hotKeyCaptureObject = (AddonHotKeyConfig)gson.fromJson(this.preferenceStore.getDefaultString("objectspy.hotkey.captureObject"), AddonHotKeyConfig.class);
        this.txtCaptureObject.setText(KeyStroke.getInstance((int)this.hotKeyCaptureObject.getModifiers(), (int)this.hotKeyCaptureObject.getKeyCode()).format());
        this.chckPinWindow.setSelection(this.preferenceStore.getDefaultBoolean("objectspy.pinWindow"));
    }

    protected boolean isInitialized() {
        return this.chckPinWindow != null;
    }

    private static class KeyCaptureAdapter
    extends KeyAdapter {
        private Text text;
        private AddonHotKeyConfig hotkeyConfig;
        private List<Integer> acceptableKeycodes;
        private ObjectSpyPreferencePage parentPage;

        public KeyCaptureAdapter(Text text, AddonHotKeyConfig hotkeyConfig, List<Integer> acceptableKeycodes, ObjectSpyPreferencePage parentPage) {
            this.text = text;
            this.hotkeyConfig = hotkeyConfig;
            this.acceptableKeycodes = acceptableKeycodes;
            this.parentPage = parentPage;
        }

        public void keyPressed(KeyEvent keyEvent) {
            keyEvent.doit = false;
            int keyCode = keyEvent.keyCode;
            int modifiers = keyEvent.stateMask;
            if (modifiers == 0 || (modifiers & 0x400000) != 0 || this.acceptableKeycodes.indexOf(keyCode) == -1) {
                this.setParentPageMessage(ObjectspyMessageConstants.WARN_MSG_INVALID_KEY_COMBINATION, 2);
                return;
            }
            this.text.setText(KeyStroke.getInstance((int)modifiers, (int)keyCode).format());
            this.hotkeyConfig.setKeyCode(keyCode);
            this.hotkeyConfig.setModifiers(modifiers);
            this.setParentPageMessage(null, 1);
        }

        protected void setParentPageMessage(final String message, final int type) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    parentPage.setMessage(message, type);
                }
            });
        }
    }
}

