/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.services;

import com.kms.katalon.session.constants.FeatureConstants;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureService;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Creatable
@Singleton
public class FeatureService
implements IFeatureService {
    private static IFeatureService instance;
    private Map<ProductFeature, Object> features;

    public static IFeatureService getInstance() {
        if (Objects.isNull(instance)) {
            BundleContext bundleContext = FrameworkUtil.getBundle(FeatureService.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (IFeatureService)ContextInjectionFactory.make(FeatureService.class, (IEclipseContext)context);
        }
        return instance;
    }

    public void setFeatures(Map<ProductFeature, Object> features) {
        if (this.features == null) {
            this.features = features;
            return;
        }
        this.features.putAll(features);
    }

    public void enable(ProductFeature feature, Object value) {
        if (this.features == null) {
            this.features = new HashMap<ProductFeature, Object>();
        }
        this.features.put(feature, value);
    }

    public void clear() {
        if (this.features != null) {
            this.features.clear();
        }
    }

    public boolean getBoolean(ProductFeature feature) {
        if (this.features == null || !this.features.containsKey(feature)) {
            return false;
        }
        Object value = this.features.get(feature);
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return numberValue.intValue() == FeatureConstants.UNLIMITED_QUOTA || numberValue.intValue() > 0;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            try {
                int intValue = Integer.parseInt(stringValue);
                return intValue == FeatureConstants.UNLIMITED_QUOTA || intValue > 0;
            }
            catch (NumberFormatException numberFormatException) {
                return StringUtils.isNotEmpty((CharSequence)stringValue);
            }
        }
        return false;
    }

    public String getString(ProductFeature feature) {
        if (this.features == null || !this.features.containsKey(feature)) {
            return null;
        }
        Object value = this.features.get(feature);
        if (value instanceof String) {
            String stringValue = (String)value;
            return stringValue;
        }
        return value != null ? value.toString() : null;
    }

    public int getInt(ProductFeature feature) {
        Boolean booleanValue;
        if (this.features == null || !this.features.containsKey(feature)) {
            return 0;
        }
        Object value = this.features.get(feature);
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return numberValue.intValue();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (value instanceof Boolean && (booleanValue = (Boolean)value).booleanValue()) {
            return FeatureConstants.UNLIMITED_QUOTA;
        }
        return 0;
    }

    public <T> T getValue(ProductFeature feature, Class<T> clazz) {
        if (this.features == null || !this.features.containsKey(feature)) {
            return null;
        }
        Object value = this.features.get(feature);
        if (value != null && clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }
}

