/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.RememberMeOption;
import com.kms.katalon.session.core.model.RememberedApiKey;
import com.kms.katalon.session.core.model.RememberedCredential;
import com.kms.katalon.session.core.model.User;
import com.kms.katalon.session.core.services.ISessionService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class SessionService
implements ISessionService {
    public final String USER_HOME_DIR = System.getProperty("user.home");
    public final String KATALON_HOME_ENV_NAME = "KATALON_HOME";
    public final String KATALON_HOME_DIR = System.getenv("KATALON_HOME") != null ? System.getenv("KATALON_HOME") : this.USER_HOME_DIR;
    public final String KATALON_USER_DIR_LOCATION = this.KATALON_HOME_DIR + File.separator + ".katalon";
    public final String KATALON_SESSION_INFO_FILE_LOCATION = this.KATALON_USER_DIR_LOCATION + File.separator + "session.properties";
    private final Logger logger = LoggerFactory.getLogger(SessionService.class);
    private ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private Properties sessionProperties;

    public void reset() {
        this.sessionProperties = this.getSessionProperties();
        if (Objects.nonNull(this.sessionProperties)) {
            this.sessionProperties.clear();
        }
        this.saveSessionProperties();
    }

    public Account getAccount() throws JsonMappingException, JsonProcessingException {
        String json = this.getSessionProperty("account");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            return (Account)this.objectMapper.readValue(json, Account.class);
        }
        return null;
    }

    public AuthenticationToken getAdminToken() {
        String json = this.getSessionProperty("adminToken");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (AuthenticationToken)this.objectMapper.readValue(json, AuthenticationToken.class);
            }
            catch (JsonProcessingException e) {
                this.logger.error("Failed to get admin token from session properties!", (Throwable)e);
            }
        }
        return null;
    }

    public String getIdpType() {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.getSessionProperty("idpType"), "basic"});
    }

    public AuthenticationToken getKatOneToken() throws JsonMappingException, JsonProcessingException {
        String json = this.getSessionProperty("katOneToken");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            return (AuthenticationToken)this.objectMapper.readValue(json, AuthenticationToken.class);
        }
        return null;
    }

    public String getLicense() {
        return this.getSessionProperty("license");
    }

    public Organization getOrganization() {
        String json = this.getSessionProperty("organization");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (Organization)this.objectMapper.readValue(json, Organization.class);
            }
            catch (JsonProcessingException jsonProcessingException) {}
        }
        return null;
    }

    private Properties getSessionProperties() {
        if (this.sessionProperties != null) {
            return this.sessionProperties;
        }
        File sessionPropFile = new File(this.KATALON_SESSION_INFO_FILE_LOCATION);
        File katalonDir = new File(this.KATALON_USER_DIR_LOCATION);
        if (!sessionPropFile.exists()) {
            if (!katalonDir.exists()) {
                katalonDir.mkdir();
            }
            try {
                sessionPropFile.createNewFile();
            }
            catch (Exception exception) {
                this.logger.info("Failed to create session properties file!");
            }
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream in = new FileInputStream(sessionPropFile);){
                this.sessionProperties = new Properties();
                this.sessionProperties.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            this.logger.info("Failed to load session properties!");
            this.sessionProperties = null;
        }
        return this.sessionProperties;
    }

    private String getSessionProperty(String key) {
        Properties sessionProps = this.getSessionProperties();
        if (sessionProps != null && sessionProps.containsKey(key)) {
            return sessionProps.getProperty(key);
        }
        return null;
    }

    public String getSubDomain() {
        return this.getSessionProperty("subDomain");
    }

    public User getUser() throws JsonMappingException, JsonProcessingException {
        String json = this.getSessionProperty("user");
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (User)this.objectMapper.readValue(json, User.class);
    }

    public void saveAccount(Account account) throws JsonProcessingException {
        if (Objects.nonNull(account)) {
            String json = this.objectMapper.writeValueAsString((Object)account);
            this.setSessionProperty("account", json, true);
        } else {
            this.setSessionProperty("account", null, true);
        }
    }

    public void saveAdminToken(AuthenticationToken adminToken) throws JsonProcessingException {
        if (Objects.nonNull(adminToken)) {
            String json = this.objectMapper.writeValueAsString((Object)adminToken);
            this.setSessionProperty("adminToken", json, true);
        } else {
            this.setSessionProperty("adminToken", null, true);
        }
    }

    public void saveIdpType(String idpType) {
        this.setSessionProperty("idpType", idpType != null ? idpType.toString() : null, true);
    }

    public void saveKatOneToken(AuthenticationToken katOneToken) throws JsonProcessingException {
        if (Objects.nonNull(katOneToken)) {
            String json = this.objectMapper.writeValueAsString((Object)katOneToken);
            this.setSessionProperty("katOneToken", json, true);
        } else {
            this.setSessionProperty("katOneToken", null, true);
        }
    }

    public void saveLicense(String license) {
        this.setSessionProperty("license", license, true);
    }

    public void saveOrganization(Organization organization) throws JsonProcessingException {
        if (Objects.nonNull(organization)) {
            String json = this.objectMapper.writeValueAsString((Object)organization);
            this.setSessionProperty("organization", json, true);
        } else {
            this.setSessionProperty("organization", null, true);
        }
    }

    private void saveSessionProperties() {
        if (this.sessionProperties == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileOutputStream out = new FileOutputStream(this.KATALON_SESSION_INFO_FILE_LOCATION);){
                this.sessionProperties.store(out, this.KATALON_USER_DIR_LOCATION);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            this.logger.info("Failed to save session properties!");
        }
    }

    public void saveSubDomain(String subDomain) {
        this.setSessionProperty("subDomain", subDomain, true);
    }

    public void saveUser(User user) throws JsonProcessingException {
        if (Objects.nonNull(user)) {
            String json = this.objectMapper.writeValueAsString((Object)user);
            this.setSessionProperty("user", json, true);
        } else {
            this.setSessionProperty("user", null, true);
        }
    }

    private void setSessionProperty(String key, String value, boolean autoSave) {
        Properties sessionProps = this.getSessionProperties();
        if (Objects.nonNull(value)) {
            sessionProps.setProperty(key, value);
        } else {
            sessionProps.remove(key);
        }
        if (autoSave) {
            this.saveSessionProperties();
        }
    }

    public boolean shouldShowBrowserLoginAvailableDialog() {
        String rawValue = this.getSessionProperty("shouldShowBrowserLoginAvailableDialog");
        if (StringUtils.isBlank((CharSequence)rawValue)) {
            return true;
        }
        return Boolean.valueOf(rawValue);
    }

    public void setShouldShowBrowserLoginAvailableDialog(boolean shouldDisplay) {
        this.setSessionProperty("shouldShowBrowserLoginAvailableDialog", !shouldDisplay ? "false" : "true", true);
    }

    public RememberMeOption getRememberMeOption() {
        String optionValue = (String)StringUtils.defaultIfEmpty((CharSequence)ApplicationInfo.getAppProperty((String)"session.rememberMeOption"), (CharSequence)RememberMeOption.UNSET.name());
        try {
            return RememberMeOption.valueOf((String)optionValue);
        }
        catch (Exception exception) {
            return RememberMeOption.UNSET;
        }
    }

    public void setRememberMeOption(RememberMeOption option) {
        ApplicationInfo.setAppProperty((String)"session.rememberMeOption", (String)option.name(), (boolean)true);
    }

    public void saveRememberedCredential(RememberedCredential credential) throws StorageException, IOException {
        if (credential == null) {
            return;
        }
        ISecurePreferences securePreferences = this.loadSecurePreferences();
        if (credential instanceof RememberedApiKey) {
            RememberedApiKey rememberedApiKey = (RememberedApiKey)credential;
            securePreferences.put("session.rememberMeCredential.type", RememberedCredential.CredentialType.API_KEY.name(), true);
            securePreferences.put("session.rememberMeCredential.value", rememberedApiKey.getValue(), true);
            securePreferences.flush();
            return;
        }
        this.logger.warn("Unsupported remembered credential type: " + credential.getClass().getName());
    }

    public RememberedCredential getRememberedCredential() throws StorageException, JsonMappingException, JsonProcessingException {
        ISecurePreferences securePreferences = this.loadSecurePreferences();
        RememberedCredential.CredentialType credentialType = RememberedCredential.CredentialType.valueOf((String)securePreferences.get("session.rememberMeCredential.type", null));
        if (credentialType == RememberedCredential.CredentialType.API_KEY) {
            String value = securePreferences.get("session.rememberMeCredential.value", null);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return new RememberedApiKey(value);
            }
            return null;
        }
        this.logger.warn("Unsupported remembered credential type: " + String.valueOf(credentialType));
        return null;
    }

    public void clearRememberedCredential() throws IOException {
        ISecurePreferences securePreferences = this.loadSecurePreferences();
        securePreferences.remove("session.rememberMeCredential.type");
        securePreferences.remove("session.rememberMeCredential.value");
        securePreferences.flush();
        this.logger.info("Remembered credential cleared successfully.");
    }

    private ISecurePreferences loadSecurePreferences() {
        ISecurePreferences securePreferences = null;
        try {
            File secureStorageFolder = Paths.get(SystemUtils.getUserHome().toString(), ".katalon", "session").toFile();
            File secureStorageFile = new File(secureStorageFolder, "secure");
            securePreferences = SecurePreferencesFactory.open((URL)secureStorageFile.toURI().toURL(), null);
            if (securePreferences != null) {
                securePreferences.flush();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to load secure preferences", (Object)e.getMessage());
        }
        return securePreferences;
    }
}

