/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.util;

import com.google.common.io.CharStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import net.lightbody.bmp.mitm.exception.UncheckedIOException;

public class ClasspathResourceUtil {
    public static String classpathResourceToString(String resource, Charset charset) throws UncheckedIOException {
        if (resource == null) {
            throw new IllegalArgumentException("Classpath resource to load cannot be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Character set cannot be null");
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream resourceAsStream = ClasspathResourceUtil.class.getResourceAsStream(resource);){
                if (resourceAsStream == null) {
                    throw new UncheckedIOException(new FileNotFoundException("Unable to locate classpath resource: " + resource));
                }
                InputStreamReader resourceReader = new InputStreamReader(resourceAsStream, charset);
                return CharStreams.toString((Readable)resourceReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error occurred while reading classpath resource", e);
        }
    }
}

