package com.kms.katalon.core.appium.driver;

import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

import org.apache.http.client.utils.URIBuilder;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kms.katalon.core.appium.constants.AppiumStringConstants;
import com.kms.katalon.core.appium.constants.CoreAppiumMessageConstants;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.config.ProxyConfig;

public class AppiumRequestService {

    private static final String APPIUM_URL_STATUS_PATH = "/status";

    private final KeywordLogger logger = KeywordLogger.getInstance(this.getClass());

    private String appiumServerUrl;

    public AppiumRequestService(String appiumServerUrl) {
        this.appiumServerUrl = appiumServerUrl;
    }

    public void logAppiumInfo() {
        String appiumJsonResponseStatus = "";
        try {
            var httpClient = new ApacheHttpClient();

            ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
            ProxyConfig proxyConfig = proxyInfo == null ? null : proxyInfo.toNewProxyConfigModel();
            Map<String, String> headers = new HashMap<String, String>();

            HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();

            URI baseUri = new URI(appiumServerUrl);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme())
                    .setHost(baseUri.getHost())
                    .setPort(baseUri.getPort())
                    .setPath(APPIUM_URL_STATUS_PATH)
                    .build();

            var response = httpClient.get(uri, httpOptions);
            appiumJsonResponseStatus = response.getBody();

            JsonObject parser = new JsonParser().parse(appiumJsonResponseStatus).getAsJsonObject();
            String appiumVersion = parser.getAsJsonObject("value")
                    .getAsJsonObject("build")
                    .getAsJsonPrimitive("version")
                    .getAsString();

            logger.logRunData(AppiumStringConstants.XML_LOG_APPIUM_VERSION, appiumVersion);
            logger.logRunData(CoreAppiumMessageConstants.XML_LOG_APPIUM_STATUS, parser.toString());
        } catch (IllegalStateException e) {
            logger.logRunData("appiumStatus", appiumJsonResponseStatus);
        } catch (Exception e) {
            logger.logWarning(
                    MessageFormat.format(AppiumStringConstants.MSG_UNABLE_TO_GET_APPIUM_STATUS, e.getMessage()), null,
                    e);
        }
    }
}
