package com.kms.katalon.core.webservice.common;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper.LocalFileProvider;
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper.RemoteFileProvider;

public class ResourceResolver implements LSResourceResolver {

    private LocalFileProvider localFileProvider;

    private RemoteFileProvider remoteFileProvider;
    
    private KeywordLogger logger = KeywordLogger.getInstance(ResourceResolver.class);

    public ResourceResolver(LocalFileProvider localFileProvider, RemoteFileProvider remoteFileProvider) {
        this.localFileProvider = localFileProvider;
        this.remoteFileProvider = remoteFileProvider;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        try {
            String resource = localFileProvider != null ? localFileProvider.read(systemId) : null;
            if (StringUtils.isBlank(resource)) {
                resource = remoteFileProvider != null ? remoteFileProvider.fetch(systemId) : null;
            }
            InputStream resourceAsStream = IOUtils.toInputStream(resource, StandardCharsets.UTF_8);
            Objects.requireNonNull(resourceAsStream,
                    String.format("Could not find the specified xsd file: %s", systemId));
            return new Input(publicId, systemId, resourceAsStream);
        } catch (Exception error) {
            logger.logError(error.getMessage());
        }
        return null;
    }
}
