package com.kms.katalon.core.mobile.keyword.builtin

import java.text.MessageFormat

import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.helper.KeywordHelper
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.helper.MobileCommonHelper
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject

import groovy.transform.CompileStatic

@Action(value = "getAttribute")
public class GetAttributeKeyword extends MobileAbstractKeyword {


    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        String name = (String) params[1]
        int timeout = (int) params[2]
        FailureHandling flowControl = (FailureHandling)(params.length > 3 && params[3] instanceof FailureHandling ? params[3] : RunConfiguration.getDefaultFailureHandling())
        return getAttribute(to,name,timeout,flowControl)
    }

    @CompileStatic
    public String getAttribute(TestObject to, String name, int timeout, FailureHandling flowControl) throws StepFailedException {
        return MobileKeywordMain.runKeyword({
            KeywordHelper.checkTestObjectParameter(to)
            timeout = MobileCommonHelper.checkTimeout(timeout)
            WebElement element = findElement(to, timeout)
            if (element == null) {
                MobileKeywordMain.stepFailed(MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), flowControl, null, true)
                return null
            }
            String val = MobileCommonHelper.getAttributeValue(element, name)
            logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_ELEMENT_HAS_ATTR, to.getObjectId(), name, val))
            return val
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), to != null ? MessageFormat.format(StringConstants.KW_MSG_FAILED_TO_GET_ELEMENT_X_ATTR_Y, [to.getObjectId(), name] as Object[]) : StringConstants.KW_MSG_FAILED_TO_GET_ELEMENT_ATTR)
    }
}
