package com.kms.katalon.core.mobile.keyword.builtin

import java.text.MessageFormat
import java.time.Duration

import org.openqa.selenium.WebDriverException
import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumBy
import io.appium.java_client.AppiumDriver
import io.appium.java_client.HasOnScreenKeyboard
import io.appium.java_client.ios.IOSDriver
import io.appium.java_client.remote.HideKeyboardStrategy

@Action(value = "hideKeyboard")
public class HideKeyboardKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        FailureHandling flowControl = (FailureHandling)(params.length > 0 && params[0] instanceof FailureHandling ? params[0] : RunConfiguration.getDefaultFailureHandling())
        hideKeyboard(flowControl)
    }

    public void hideKeyboard(FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver()
            if (!((HasOnScreenKeyboard) driver).isKeyboardShown()) {
                return;
            }

            WebDriverException exception = null;

            try {
                // Use default - tapOutside
                driver.executeScript("mobile: hideKeyboard");
            } catch (WebDriverException e) {
                if (driver instanceof IOSDriver) {
                    // default hide keyboard strategy (tap outside) failed on iOS, use "Done" button
                    String[] keys = ["Done", "Return"] as String[]
                    for (String key : keys) {
                        try {
                            Map<String, Object> params = new HashMap<>();
                            params.put("strategy", HideKeyboardStrategy.PRESS_KEY);
                            params.put("key", key);
                            driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0));
                            driver.executeScript("mobile: hideKeyboard", params);
                            break;
                        } catch (WebDriverException wde) {
                            if (exception == null) {
                                exception = wde;
                            }

                            String classChain = MessageFormat.format("**/XCUIElementTypeButton[`label == ''{0}''`]",
                                    key);
                            try {
                                driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0));
                                WebElement button = driver.findElement(AppiumBy.iOSClassChain(classChain));
                                if (button != null) {
                                    button.click();
                                    break;
                                }
                            } catch (WebDriverException ignored) {}

                            // Wait for the keyboard gone
                            try {
                                Thread.sleep(500);
                            } catch (InterruptedException ignored) {}
                        }
                    }
                }
            }

            // Verify keyboard state
            List<WebElement> keyboardElements = new ArrayList<WebElement>();
            try {
                driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0));
                keyboardElements = driver.findElements(AppiumBy.iOSClassChain("**/XCUIElementTypeKeyboard"));
            } catch (WebDriverException ignored) {}

            if (!keyboardElements.isEmpty() && exception != null) {
                throw exception;
            }

            logger.logPassed(StringConstants.KW_LOG_PASSED_HIDE_KEYBOARD)
        }, flowControl,RunConfiguration.getTakeScreenshotOption(), StringConstants.KW_MSG_CANNOT_HIDE_KEYBOARD)
    }
}
