package com.kms.katalon.core.mobile.keyword.builtin;

import org.apache.commons.lang3.StringUtils

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.CoreMobileMessageConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver
import io.appium.java_client.android.AndroidDriver
import io.appium.java_client.ios.IOSDriver
import io.appium.java_client.remote.SupportsContextSwitching

@Action(value = "performTouchID")
public class PerformTouchIDKeyword extends MobileAbstractKeyword {
    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        boolean match = (boolean) params[0]
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        performTouchID(match,flowControl)
    }

    @CompileStatic
    public void performTouchID(boolean match, FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver()

            if (driver instanceof AndroidDriver) {
                MobileKeywordMain.stepFailed(CoreMobileMessageConstants.KW_MSG_TOUCH_ID_SUPPORTS_IOS_APP_ONLY, flowControl, null, true)
                return
            } else {
                IOSDriver iOSDriver = (IOSDriver) driver

                String deviceModel = MobileDriverFactory.getDeviceModel()
                if (!StringUtils.containsIgnoreCase(deviceModel, "simulator")) {
                    logger.logWarning(CoreMobileMessageConstants.KW_MSG_TOUCH_ID_NOT_AVAILABLE_ON_PHYSICAL_MOBILE_DEVICES)
                    return
                } else {
                    boolean isTouchIDEnrolled = iOSDriver.executeScript("mobile:isBiometricEnrolled")
                    if (!isTouchIDEnrolled) {
                        MobileKeywordMain.stepFailed(CoreMobileMessageConstants.KW_MSG_TOUCH_ID_NOT_ENROLLED, flowControl, null, true)
                        return
                    }
                }

                iOSDriver.performTouchID(match)

                logger.logPassed(CoreMobileMessageConstants.KW_MSG_PASSED_PERFORM_TOUCH_ID)
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), CoreMobileMessageConstants.KW_MSG_FAILED_PERFORM_TOUCH_ID)
    }
}
