package com.kms.katalon.core.webui.common.controller;

import java.io.IOException;

import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;

public class WaitForEnabledPhase extends ElementWaitingPhase {

    public WaitForEnabledPhase(JavascriptExecutor webDriver) {
        super(webDriver);
    }

    @Override
    protected String getWaitingScript() {
        try {
            return super.getInteractableWaitUtilScript() + super.getWaitingScript() + """
                          function checkEnabled(element) {
                              return !getAriaDisabled(element);
                          }

                          waitWithDOMMutation(() => checkEnabled(element), timeout).then((waited) => {
                              notifyWaitingResult({ result: waited
                                  ? ElementWaitingInteractableState.DONE
                                  : ElementWaitingInteractableState.TIMED_OUT });
                          }).catch(notifyWaitingError);
                    """;
        } catch (IOException e) {
            throw new JavascriptException("Failed to load interactable wait util script", e);
        }
    }
}
