package com.kms.katalon.core.webui.driver;

import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.chrome.ChromeDriverBuilder;
import com.kms.katalon.core.webui.driver.chrome.ChromeHeadlessDriverBuilder;
import com.kms.katalon.core.webui.driver.edge.EdgeChromiumDriverBuilder;
import com.kms.katalon.core.webui.driver.firefox.FirefoxDriverBuilder;
import com.kms.katalon.core.webui.driver.firefox.FirefoxHeadlessDriverBuilder;
import com.kms.katalon.core.webui.driver.remote.GenericRemoteDriverBuilder;
import com.kms.katalon.core.webui.driver.safari.SafariDriverBuilder;

public class DriverBuilderFactory {
    public static IDriverBuilder getDriverBuilder(WebUIDriverType driverType) {
        switch (driverType) {
            case FIREFOX_DRIVER -> {
                return new FirefoxDriverBuilder();
            }

            case SAFARI_DRIVER -> {
                return new SafariDriverBuilder();
            }

            case CHROME_DRIVER -> {
                return new ChromeDriverBuilder();
            }

            case REMOTE_WEB_DRIVER -> {
                return new GenericRemoteDriverBuilder();
            }

            case KOBITON_WEB_DRIVER -> {
                return new GenericRemoteDriverBuilder();
            }

            case TESTCLOUD_DRIVER -> {
                return new GenericRemoteDriverBuilder();
            }

            case ANDROID_DRIVER -> {
                return new MobileDriverBuilder().driverType(WebUIDriverType.ANDROID_DRIVER);
            }

            case IOS_DRIVER -> {
                return new MobileDriverBuilder().driverType(WebUIDriverType.IOS_DRIVER);
            }

            case EDGE_CHROMIUM_DRIVER -> {
                return new EdgeChromiumDriverBuilder();
            }

            case HEADLESS_DRIVER -> {
                return new ChromeHeadlessDriverBuilder();
            }

            case FIREFOX_HEADLESS_DRIVER -> {
                return new FirefoxHeadlessDriverBuilder();
            }

            default -> throw new StepFailedException(StringConstants.DRI_ERROR_MSG_NO_BROWSER_SET);
        }
    }
}
