package com.kms.katalon.core.webui.driver.safari;

import java.io.IOException;
import java.util.Map;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.safari.SafariOptions;

import com.kms.katalon.core.webui.driver.AbstractDriverBuilder;
import com.kms.katalon.selenium.constant.SeleniumW3CCapabilityConstant;
import com.kms.katalon.selenium.driver.CSafariDriver;

public class SafariDriverBuilder extends AbstractDriverBuilder {
    @Override
    protected AbstractDriverOptions<?> createOptions(Capabilities capabilities) {
        return new SafariOptions().merge(capabilities);
    }

    @Override
    protected WebDriver createDriver(AbstractDriverOptions<?> options) {
        if (!(options instanceof SafariOptions safariOptions)) {
            return null;
        }

        return new CSafariDriver(safariOptions, driverConfigProvider.getActionDelayInMilisecond());
    }

    // Skipping proxy configuration for Safari browser.
    // SafariDriver does not support setting proxy settings via DesiredCapabilities.
    // This is a known limitation in Safari’s WebDriver implementation.
    // Refer to the following discussion and issue tracker for more details:
    // - https://groups.google.com/g/selenium-users/c/UIPZ7u6W-ZI
    // - https://github.com/SeleniumHQ/selenium/issues/10401
    @Override
    protected AbstractDriverOptions<?> applyProxy(AbstractDriverOptions<?> options) throws IOException {
        return options;
    }
    
    @Override
    protected Capabilities ignoreUnhandledPrompt(Capabilities capabilities) {
        var currentBehavior = capabilities.getCapability(SeleniumW3CCapabilityConstant.UNHANDLED_PROMPT_BEHAVIOR_CAP);

        if (null != currentBehavior) {
            return capabilities;
        }

        var newCaps = new MutableCapabilities(capabilities);
        newCaps.setCapability(SeleniumW3CCapabilityConstant.UNHANDLED_PROMPT_BEHAVIOR_CAP, "ignore");
        return newCaps;
    }
}
