package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat

import org.openqa.selenium.JavascriptExecutor
import org.openqa.selenium.WebDriver
import org.openqa.selenium.WebElement
import org.openqa.selenium.support.ui.Select

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain

import groovy.transform.CompileStatic

@Action(value = "deselectOptionByIndex")
public class DeselectOptionByIndexKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        Object range = (Object) params[1]
        FailureHandling flowControl = (FailureHandling)(params.length > 2 && params[2] instanceof FailureHandling ? params[2] : RunConfiguration.getDefaultFailureHandling())
        deselectOptionByIndex(to,range,flowControl)
    }

    @CompileStatic
    public void deselectOptionByIndex(TestObject to, Object range, FailureHandling flowControl) throws StepFailedException {
        WebDriver driver = DriverFactory.getWebDriver()

        long timeoutInMillis = RunConfiguration.getElementTimeoutForWebInMillis()
        
        WebUIKeywordMain.runKeywordUntilTimeout({retryContext ->
            boolean isSwitchIntoFrame = false
            try {
                WebUiCommonHelper.checkTestObjectParameter(to)
                logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_INDEX_RANGE)
                if (range == null) {
                    throw new IllegalArgumentException(StringConstants.KW_EXC_INDEX_RANGE_IS_NULL)
                }
                Integer[] indexes = WebUiCommonHelper.indexRangeToArray(String.valueOf(range))
                if (indexes.length > 0) {
                    isSwitchIntoFrame = WebUiCommonHelper.switchToParentFrame(driver, to)
                    WebElement webElement = WebUIAbstractKeyword.findWebElement(driver, to, timeoutInMillis)
                    if (webElement != null && driver instanceof JavascriptExecutor) {
                        waitElementInteractable((JavascriptExecutor) driver, webElement, timeoutInMillis, retryContext);
                    }
                    Select select = new Select(webElement)
                    WebUiCommonHelper.selectOrDeselectOptionsByIndex(select, indexes, false, to)
                }
                logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_OPTS_W_IDX_IN_X_ARE_DESELECTED_ON_OBJ, [WebUiCommonHelper.integerArrayToString(indexes), to.getObjectId()] as Object[]))
            } finally {
                if (isSwitchIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent(driver)
                }
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null && range != null) ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_DESELECT_OPT_BY_IDX_OF_OBJ, [range, to.getObjectId()] as Object[])
        : StringConstants.KW_MSG_CANNOT_DESELECT_OPT_BY_IDX)
    }
}
