package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat

import org.openqa.selenium.interactions.Actions
import org.openqa.selenium.interactions.WheelInput

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain

import groovy.transform.CompileStatic

@Action(value = "scrollFromViewportOffset")
public class ScrollFromViewportOffsetKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        int offsetX = (int) params[0]
        int offsetY = (int) params[1]
        int deltaX = (int) params[2]
        int deltaY = (int) params[3]
        FailureHandling flowControl = (FailureHandling)(params.length > 4 && params[4] instanceof FailureHandling ? params[4] : RunConfiguration.getDefaultFailureHandling())
        scrollFromViewportOffset(offsetX, offsetY, deltaX, deltaY, flowControl)
    }

    @CompileStatic
    public void scrollFromViewportOffset(int offsetX, int offsetY, int deltaX, int deltaY, FailureHandling flowControl) throws StepFailedException {
        WebUIKeywordMain.runKeyword({
            logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SCROLLING_FROM_POSITION, offsetX, offsetY))
            WheelInput.ScrollOrigin scrollOrigin = WheelInput.ScrollOrigin.fromViewport(offsetX, offsetY)
            (new Actions(DriverFactory.getWebDriver()))
                    .scrollFromOrigin(scrollOrigin, deltaX, deltaY).perform()
            logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_SCROLLING_FROM_POSITION, offsetX, offsetY))
        }, flowControl, RunConfiguration.getTakeScreenshotOption(),
        MessageFormat.format(StringConstants.KW_MSG_CANNOT_SCROLLING_FROM_POSITION, offsetX, offsetY))
    }
}
