package com.kms.katalon.core.keyword;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

public class KatalonBuiltInKeywordsUtil {

    private static final String WEB_UI_BUILT_IN_KEYWORD = "WebUiBuiltInKeywords";

    private static final String WINDOWS_BUILT_IN_KEYWORD = "WindowsBuiltinKeywords";

    private static final String WS_BUILT_IN_KEYWORD = "WSBuiltInKeywords";

    private static final String MOBILE_BUILT_IN_KEYWORD = "MobileBuiltInKeywords";

    private static final String CUCUMBER_BUILT_IN_KEYWORD = "CucumberBuiltinKeywords";

    private static final String TESTNG_BUILT_IN_KEYWORD = "TestNGBuiltinKeywords";
    
    private static final String WEB_UI_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.webui.keyword.WebUiBuiltInKeywords";
    
    private static final String WINDOWS_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.windows.keyword.WindowsBuiltinKeywords";
    
    private static final String WS_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.webservice.keyword.WSBuiltInKeywords";
    
    private static final String MOBILE_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords";
    
    private static final String CUCUMBER_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.cucumber.keyword.CucumberBuiltinKeywords";
    
    private static final String TESTNG_BUILT_IN_KEYWORD_PACKAGE = "com.kms.katalon.core.testng.keyword.TestNGBuiltinKeywords";

    private static final String WEB_UI = "WebUI";

    private static final String WINDOWS = "Windows";

    private static final String WS = "WS";

    private static final String MOBILE = "Mobile";

    private static final String CUCUMBER = "CucumberKW";

    private static final String TESTNGKW = "TestNGKW";

    public static final String FIND_CHECK_POINT = "findCheckpoint";

    public static final String FIND_TEST_CASE = "findTestCase";

    public static final String FIND_TEST_DATA = "findTestData";

    public static final String FIND_TEST_OBJECT = "findTestObject";

    public static final String FIND_WINDOWS_OBJECT = "findWindowsObject";

    private static Map<String, String> keywordName = new HashMap<String, String>();
    
    private static Map<String, String> keywordAliased = new HashMap<String, String>();
    
    private static Map<String, String> keywordPackageByKeywordName = new HashMap<String, String>();
    
    private static Map<String, String> keywordPackageByKeywordAliased = new HashMap<String, String>();

    static {
        // Keyword name to Keyword alias
        keywordName.put(WEB_UI_BUILT_IN_KEYWORD, WEB_UI);
        keywordName.put(MOBILE_BUILT_IN_KEYWORD, MOBILE);
        keywordName.put(WS_BUILT_IN_KEYWORD, WS);
        keywordName.put(WINDOWS_BUILT_IN_KEYWORD, WINDOWS);
        keywordName.put(CUCUMBER_BUILT_IN_KEYWORD, CUCUMBER);
        keywordName.put(TESTNG_BUILT_IN_KEYWORD, TESTNGKW);
        
        // Keyword alias to Keyword name
        keywordAliased.put(WEB_UI, WEB_UI_BUILT_IN_KEYWORD);
        keywordAliased.put(MOBILE, MOBILE_BUILT_IN_KEYWORD);
        keywordAliased.put(WS, WS_BUILT_IN_KEYWORD);
        keywordAliased.put(WINDOWS, WINDOWS_BUILT_IN_KEYWORD);
        keywordAliased.put(CUCUMBER, CUCUMBER_BUILT_IN_KEYWORD);
        keywordAliased.put(TESTNGKW, TESTNG_BUILT_IN_KEYWORD);
        
        // Keyword name to Keyword package
        keywordPackageByKeywordName.put(WEB_UI_BUILT_IN_KEYWORD, WEB_UI_BUILT_IN_KEYWORD_PACKAGE);
        keywordPackageByKeywordName.put(MOBILE_BUILT_IN_KEYWORD, MOBILE_BUILT_IN_KEYWORD_PACKAGE);
        keywordPackageByKeywordName.put(WS_BUILT_IN_KEYWORD, WS_BUILT_IN_KEYWORD_PACKAGE);
        keywordPackageByKeywordName.put(WINDOWS_BUILT_IN_KEYWORD, WINDOWS_BUILT_IN_KEYWORD_PACKAGE);
        keywordPackageByKeywordName.put(CUCUMBER_BUILT_IN_KEYWORD, CUCUMBER_BUILT_IN_KEYWORD_PACKAGE);
        keywordPackageByKeywordName.put(TESTNG_BUILT_IN_KEYWORD, TESTNG_BUILT_IN_KEYWORD_PACKAGE);
        
        // Keyword alias to keyword package
        keywordPackageByKeywordAliased.put(WEB_UI, WEB_UI_BUILT_IN_KEYWORD_PACKAGE);
        keywordPackageByKeywordAliased.put(MOBILE, MOBILE_BUILT_IN_KEYWORD_PACKAGE);
        keywordPackageByKeywordAliased.put(WS, WS_BUILT_IN_KEYWORD_PACKAGE);
        keywordPackageByKeywordAliased.put(WINDOWS, WINDOWS_BUILT_IN_KEYWORD_PACKAGE);
        keywordPackageByKeywordAliased.put(CUCUMBER, CUCUMBER_BUILT_IN_KEYWORD_PACKAGE);
        keywordPackageByKeywordAliased.put(TESTNGKW, TESTNG_BUILT_IN_KEYWORD_PACKAGE);
    };
    
    private KatalonBuiltInKeywordsUtil() {
        throw new IllegalStateException("This is Katalon built-in keywords utility class");
    }

    public static String getAliasedByKeywordName(String keywordName) {
        return KatalonBuiltInKeywordsUtil.keywordName.get(keywordName);
    }

    public static String getKeywordNameByAliased(String aliased) {
        return KatalonBuiltInKeywordsUtil.keywordAliased.get(aliased);
    }
    
    public static String getKeywordPackageByKeywordName(String keywordName) {
        return KatalonBuiltInKeywordsUtil.keywordPackageByKeywordName.get(keywordName);
    }
    
    public static String getKeywordPackageByKeywordAliased(String keywordName) {
        return KatalonBuiltInKeywordsUtil.keywordPackageByKeywordAliased.get(keywordName);
    }
    
    public static String getKeywordAliasedByKeywordClass(String keywordClass) {
        String[] keywordSplit = StringUtils.split(keywordClass, '.');
        String keywordName = keywordSplit[keywordSplit.length - 1];
        return getAliasedByKeywordName(keywordName);
    }
    
    public static boolean isNotKeywordProposalByKatalon(String keywordClass) {
        String[] keywordSplit = StringUtils.split(keywordClass, '.');
        String keywordNameProposal = keywordSplit[keywordSplit.length - 1];
        return keywordNameProposal.equals("BuiltinKeywords");
    }
    
    public static boolean isAliasKeyword(String keyword) {
        return KatalonBuiltInKeywordsUtil.keywordAliased.get(keyword) != null;
    }
    
    public static boolean isKeywordName(String keyword) {
        return KatalonBuiltInKeywordsUtil.keywordName.get(keyword) != null;
    }
}
