package com.kms.katalon.core.testobject.authorization;

import java.io.Serializable;
import java.util.Map;

import org.apache.commons.lang.builder.EqualsBuilder;

public class BasicRequestAuthorization implements RequestAuthorization, Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private String authorizationType;

    private Map<String, String> authorizationInfo;
    
    @Override
    public String getAuthorizationType() {
        return authorizationType;
    }
    
    @Override
    public void setAuthorizationType(String authorizationType) {
        this.authorizationType = authorizationType;
    }
    
    @Override
    public Map<String, String> getAuthorizationInfo() {
        return authorizationInfo;
    }
    
    @Override
    public void setAuthorizationInfo(Map<String, String> authorizationInfo) {
        this.authorizationInfo = authorizationInfo;
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((authorizationInfo == null) ? 0 : authorizationInfo.hashCode());
        result = prime * result + ((authorizationType == null) ? 0 : authorizationType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEquals = super.equals(obj);
        if (!(obj instanceof BasicRequestAuthorization)) {
            return false;
        }
        BasicRequestAuthorization other = (BasicRequestAuthorization) obj;
        isEquals = isEquals
                && new EqualsBuilder().append(this.getAuthorizationType(), other.getAuthorizationType()).isEquals()
                && new EqualsBuilder().append(this.getAuthorizationInfo(), other.getAuthorizationInfo()).isEquals();
        return isEquals;
    }
}
