package com.kms.katalon.core.testobject.authorization;

public enum DigestAlgorithmDirective {
    // We're using Apache HttpClient v4 which supports only below
    // algorithm methods.
    //
    // See https://hc.apache.org/httpcomponents-client-4.5.x/current/httpclient/apidocs/
    MD5("MD5"),
    MD5_SESS("MD5-sess");
	
    private final String algorithm;

    private DigestAlgorithmDirective(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getName() {
        return algorithm;
    }
    
    public static DigestAlgorithmDirective fromString(String name) {
	    for (DigestAlgorithmDirective directive : DigestAlgorithmDirective.values()) {
	        if (directive.getName().equals(name)) {
	            return directive;
	        }
	    }
	    
	    throw new IllegalArgumentException("No enum constant with name " + name);
    }
}
