package com.kms.katalon.core.util;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriver;

import com.github.kklisura.cdt.services.ChromeDevToolsService;
import com.github.kklisura.cdt.services.ChromeService;
import com.github.kklisura.cdt.services.impl.ChromeServiceImpl;
import com.github.kklisura.cdt.services.types.ChromeTab;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.util.internal.ExceptionsUtil;

public class CDTUtils {

    private final static KeywordLogger logger = KeywordLogger.getInstance(CDTUtils.class);

    private CDTUtils() {

    }

    public static ChromeDevToolsService getService(WebDriver driver) {
        try {
            String[] debugAddress = getServiceEndpoint(driver);
            if (debugAddress == null || debugAddress.length < 2) {
                return null;
            }

            String host = debugAddress[0];
            int port = Integer.parseInt(debugAddress[1]);

            ChromeService chromeService = new ChromeServiceImpl(host, port);
            List<ChromeTab> tabs = chromeService.getTabs();

            String currentUrl = driver.getCurrentUrl();
            if (currentUrl.equals("chrome://new-tab-page/")) {
                // Applying desired capabilities to use the existing profile browser
                currentUrl = "chrome://newtab/";
            }

            for (ChromeTab tabI : tabs) {
                if (tabI.getUrl().equals(currentUrl)) {
                    return chromeService.createDevToolsService(tabI);
                }
            }
        } catch (Exception ex) {
            logger.logDebug(ExceptionsUtil.getStackTraceForThrowable(ex));
        }

        return null;
    }

    @SuppressWarnings("unchecked")
    public static String[] getServiceEndpoint(WebDriver driver) {
        HasCapabilities hashCapabilities = ((HasCapabilities) driver);
        Map<String, Object> capabilities = hashCapabilities.getCapabilities().asMap();

        if (capabilities.containsKey("goog:chromeOptions")) {
            capabilities = (Map<String, Object>) capabilities.get("goog:chromeOptions");
        } else if (capabilities.containsKey("ms:edgeOptions")) {
            capabilities = (Map<String, Object>) capabilities.get("ms:edgeOptions");
        } else {
            return new String[0];
        }

        String debugAddress = (String) capabilities.get("debuggerAddress");
        return StringUtils.isNotBlank(debugAddress) ? debugAddress.split(":") : new String[0];
    }
}
