package com.kms.katalon.core.util;

import java.io.IOException;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuUtil {
    private static Logger logger = LoggerFactory.getLogger(CpuUtil.class);

    public static String getCpuArch() {
        String cpuArch = System.getProperty("os.arch").toLowerCase();
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.toLowerCase().contains("mac")) {
            ProcessBuilder pb = new ProcessBuilder("sysctl", "-n", "machdep.cpu.brand_string");
            try {
                Process process = pb.start();
                String cpuName = IOUtils.toString(process.getInputStream(), "UTF-8");
                if (cpuName.toLowerCase().startsWith("apple m")) {
                    cpuArch = "arm64";
                }
            } catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        return cpuArch;
    }
}
