package com.kms.katalon.core.util.internal;

import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

public class DateUtil {
    public static final DecimalFormat SECOND_FORMAT = new DecimalFormat("#0.000");

    public static String getElapsedTime(long startTime, long endTime) {
        if (endTime < startTime) {
            return "";
        }
        long totalMillis = endTime - startTime;
        long totalSeconds = totalMillis / 1000;
        long totalMinutes = totalSeconds / 60;

        int elapsedMillis = (int) (totalMillis % 1000);
        double elapsedSeconds = (int) (totalSeconds % 60) + ((double) elapsedMillis / 1000);
        int elapsedMinutes = (int) (totalMinutes % 60);
        int elapsedHours = (int) (totalMinutes / 60);

        StringBuilder elapsedTimeBuilder = new StringBuilder();
        if (elapsedHours > 0) {
            elapsedTimeBuilder.append(Integer.toString(elapsedHours)).append("h - ");
        }

        if (elapsedMinutes > 0) {
            elapsedTimeBuilder.append(Integer.toString(elapsedMinutes)).append("m - ");
        }
        elapsedTimeBuilder.append(SECOND_FORMAT.format(elapsedSeconds)).append("s");

        return elapsedTimeBuilder.toString();
    }

    public static String getDateTimeFormatted(long timeValue) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
        return getDateTimeFormatted(timeValue, formatter);
    }

    public static String getISOLocalDateTimeFormatted(long timeValue) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy'T'HH:mm:ss");
        return getDateTimeFormatted(timeValue, formatter);
    }

    public static String getDateTimeFormatted(long timeValue, DateTimeFormatter format) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timeValue), TimeZone.getDefault().toZoneId())
                .format(format);
    }

    public static LocalDateTime convertIsoDateTimeStringToDate(String aDateString) {
        return LocalDateTime.parse(aDateString, DateTimeFormatter.ISO_DATE_TIME);
    }

    public static String convertIsoDateTimeToString(LocalDateTime dateTime) {
        // DateTimeFormatter desiredFormatter = DateTimeFormatter.ofPattern("MMMM dd, yyyy, HH:mm:ss.SSSSSS");
        // return dateTime.format(desiredFormatter);
        return dateTime.format(DateTimeFormatter.ISO_DATE_TIME);
    }
}
