/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.ImmutableMap;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.HttpApiResponse;
import com.google.genai.errors.GenAiIOException;
import com.google.genai.types.HttpOptions;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

final class HttpApiClient
extends ApiClient {
    HttpApiClient(Optional<String> apiKey, Optional<HttpOptions> httpOptions) {
        super(apiKey, httpOptions);
    }

    HttpApiClient(Optional<String> project, Optional<String> location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions) {
        super(project, location, credentials, httpOptions);
    }

    @Override
    public ApiResponse request(String httpMethod, String path, String requestJson) {
        boolean queryBaseModel;
        boolean bl = queryBaseModel = httpMethod.equalsIgnoreCase("GET") && path.startsWith("publishers/google/models/");
        if (this.vertexAI() && !path.startsWith("projects/") && !queryBaseModel) {
            path = String.format("projects/%s/locations/%s/", this.project.get(), this.location.get()) + path;
        }
        String requestUrl = String.format("%s/%s/%s", this.httpOptions.baseUrl().get(), this.httpOptions.apiVersion().get(), path);
        if (httpMethod.equalsIgnoreCase("POST")) {
            HttpPost httpPost = new HttpPost(requestUrl);
            this.setHeaders((HttpRequestBase)httpPost);
            httpPost.setEntity((HttpEntity)new StringEntity(requestJson, ContentType.APPLICATION_JSON));
            return this.executeRequest((HttpRequestBase)httpPost);
        }
        if (httpMethod.equalsIgnoreCase("GET")) {
            HttpGet httpGet = new HttpGet(requestUrl);
            this.setHeaders((HttpRequestBase)httpGet);
            return this.executeRequest((HttpRequestBase)httpGet);
        }
        if (httpMethod.equalsIgnoreCase("DELETE")) {
            HttpDelete httpDelete = new HttpDelete(requestUrl);
            this.setHeaders((HttpRequestBase)httpDelete);
            return this.executeRequest((HttpRequestBase)httpDelete);
        }
        throw new IllegalArgumentException("Unsupported HTTP method: " + httpMethod);
    }

    private void setHeaders(HttpRequestBase request) {
        for (Map.Entry<String, String> header : this.httpOptions.headers().orElse((Map<String, String>)ImmutableMap.of()).entrySet()) {
            request.setHeader(header.getKey(), header.getValue());
        }
        if (this.apiKey.isPresent()) {
            request.setHeader("x-goog-api-key", (String)this.apiKey.get());
        } else {
            String accessToken;
            GoogleCredentials cred = (GoogleCredentials)this.credentials.orElseThrow(() -> new IllegalStateException("credentials is required"));
            try {
                cred.refreshIfExpired();
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to refresh credentials.", e);
            }
            try {
                accessToken = cred.getAccessToken().getTokenValue();
            }
            catch (NullPointerException e) {
                if (e.getMessage().contains("because the return value of \"com.google.auth.oauth2.GoogleCredentials.getAccessToken()\" is null")) {
                    accessToken = "";
                }
                throw e;
            }
            request.setHeader("Authorization", "Bearer " + accessToken);
            if (cred.getQuotaProjectId() != null) {
                request.setHeader("x-goog-user-project", cred.getQuotaProjectId());
            }
        }
    }

    private ApiResponse executeRequest(HttpRequestBase request) {
        try {
            return new HttpApiResponse(this.httpClient.execute((HttpUriRequest)request));
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to execute HTTP request.", e);
        }
    }
}

