/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.ApiClient;
import com.google.genai.ApiResponse;
import com.google.genai.JsonSerializable;
import com.google.genai.errors.GenAiIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.http.HttpEntity;

public class ResponseStream<T extends JsonSerializable>
implements Iterable<T>,
AutoCloseable {
    private final ResponseStreamIterator iterator;
    private final ApiResponse response;
    private final BufferedReader reader;

    public ResponseStream(Class<T> clazz, ApiResponse response, Object obj, String converterName) {
        InputStream responseStream;
        HttpEntity entity = response.getEntity();
        try {
            responseStream = entity.getContent();
        }
        catch (IOException e) {
            throw new GenAiIOException("Failed to read HTTP response.", e);
        }
        this.reader = new BufferedReader(new InputStreamReader(responseStream, StandardCharsets.UTF_8));
        this.iterator = new ResponseStreamIterator(clazz, this.reader, obj, converterName);
        this.response = response;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public void close() {
        block6: {
            try {
                if (this.reader == null) break block6;
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new GenAiIOException("Failed to close the response stream.", e);
                }
            }
            finally {
                if (this.response != null) {
                    this.response.close();
                }
            }
        }
    }

    class ResponseStreamIterator
    implements Iterator<T> {
        private final BufferedReader reader;
        private final Class<T> clazz;
        private final Object obj;
        private final Method converter;
        private String nextJson;

        ResponseStreamIterator(Class<T> clazz, BufferedReader reader, Object obj, String converterName) {
            this.reader = reader;
            this.clazz = clazz;
            this.nextJson = this.readNextJson();
            this.obj = obj;
            try {
                this.converter = obj.getClass().getDeclaredMethod(converterName, ApiClient.class, JsonNode.class, ObjectNode.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to find converter method " + converterName, e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextJson != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more JSON objects in the stream");
            }
            String currentJson = this.nextJson;
            this.nextJson = this.readNextJson();
            try {
                JsonNode currentJsonNode = JsonSerializable.stringToJsonNode(currentJson);
                currentJsonNode = (JsonNode)this.converter.invoke(this.obj, null, currentJsonNode, null);
                return JsonSerializable.fromJsonNode(currentJsonNode, this.clazz);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Failed to convert JSON object " + currentJson, e);
            }
        }

        private String readNextJson() {
            try {
                String line = this.reader.readLine();
                if (line == null) {
                    return null;
                }
                if (line.length() == 0) {
                    return this.readNextJson();
                }
                return line.substring("data: ".length());
            }
            catch (IOException e) {
                throw new GenAiIOException("Failed to read next JSON object from the stream", e);
            }
        }
    }
}

