/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.command;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.impl.command.KCommand;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.PlatformUI;

public class KatalonCommands {
    private static final String MORE_HELP = ComposerComponentsImplMessageConstants.COMMAND_NAME_MORE_HELP;
    private static final String KATALON_PREFERENCES = ComposerComponentsImplMessageConstants.COMMAND_NAME_KATALON_PREFERENCES;
    private static final String KATALON_QUESTIONS_AND_ANSWERS = ComposerComponentsImplMessageConstants.COMMAND_NAME_KATALON_QUESTIONS_AND_ANSWERS;
    private static final String KATALON_DOCUMENT = ComposerComponentsImplMessageConstants.COMMAND_NAME_KATALON_DOCUMENT;
    private static final String KATALON_WEBSITE = ComposerComponentsImplMessageConstants.COMMAND_NAME_KATALON_WEBSITE;
    private static final String KATALON_QUICK_GUIDE = ComposerComponentsImplMessageConstants.COMMAND_NAME_KATALON_QUICK_GUIDE;
    private static final String KATALON_HELP = ComposerComponentsImplMessageConstants.COMMAND_NAME_KATALON_HELP;
    private static final String KATALON_COMMAND = ComposerComponentsImplMessageConstants.COMMAND_NAME_KATALON_COMMAND;
    private static final String PROJECT_SETTINGS = ComposerComponentsImplMessageConstants.COMMAND_NAME_PROJECT_SETTINGS;
    private static final String COMMAND_NAME_ADD_TEST_CASE_STEP = ComposerComponentsImplMessageConstants.COMMAND_NAME_ADD_TEST_CASE_STEP;
    private static final String COMMAND_NAME_NEW = ComposerComponentsImplMessageConstants.COMMAND_NAME_NEW;
    private static final String COMMAND_NAME_OPEN = ComposerComponentsImplMessageConstants.COMMAND_NAME_OPEN;
    private static final String COMMAND_NAME_IMPORT = ComposerComponentsImplMessageConstants.COMMAND_NAME_IMPORT;
    private static final String COMMAND_NAME_EXPORT = ComposerComponentsImplMessageConstants.COMMAND_NAME_EXPORT;
    private static final String COMMAND_NAME_SPY_WEB_OBJECT = ComposerComponentsImplMessageConstants.COMMAND_NAME_SPY_WEB_OBJECT;
    private static final String COMMAND_NAME_SPY_MOBILE_OBJECT = ComposerComponentsImplMessageConstants.COMMAND_NAME_SPY_MOBILE_OBJECT;
    private static final String COMMAND_NAME_RECORD = ComposerComponentsImplMessageConstants.COMMAND_NAME_RECORD;
    private static final String COMMAND_NAME_GENERATE_COMMAND = ComposerComponentsImplMessageConstants.COMMAND_NAME_GENERATE_COMMAND;
    private static final String CHECKPOINT = GlobalStringConstants.CHECKPOINT;
    private static final String TEST_DATA = GlobalStringConstants.TEST_DATA;
    private static final String TEST_OBJECT = GlobalStringConstants.TEST_OBJECT;
    private static final String WEBSERVICE_OBJECT = ComposerComponentsImplMessageConstants.COMMAND_NAME_WEBSERVICE_OBJECT;
    private static final String WEBSERVICE_OBJECTS_FROM_SWAGGER = ComposerComponentsImplMessageConstants.COMMAND_NAME_WEBSERVICE_OBJECTS_FROM_SWAGGER;
    private static final String WEBSERVICE_OBJECTS_FROM_WSDL = ComposerComponentsImplMessageConstants.COMMAND_NAME_WEBSERVICE_OBJECTS_FROM_WSDL;
    private static final String TEST_CASE = GlobalStringConstants.TEST_CASE;
    private static final String TEST_SUITE = GlobalStringConstants.TEST_SUITE;
    private static final String TEST_SUITE_COLLECTION = ComposerComponentsImplMessageConstants.COMMAND_NAME_TEST_SUITE_COLLECTION;
    private static final String KEYWORD = GlobalStringConstants.KEYWORD;
    private static final String PACKAGE = GlobalStringConstants.PACKAGE;
    private static final String FOLDER = GlobalStringConstants.FOLDER;
    private static final String GIT = GlobalStringConstants.GIT;
    private static final String JAR = GlobalStringConstants.JAR;
    private static final String KATALON_QA_URL = ComposerComponentsImplMessageConstants.KATALON_QA_URL;
    private static final String KATALON_WEBSITE_URL = ComposerComponentsImplMessageConstants.KATALON_WEBSITE_URL;
    private static final String KATALON_DOCUMENT_URL = ComposerComponentsImplMessageConstants.KATALON_DOCUMENT_URL;
    private KCommand rootCommand;
    private MApplication application;
    private EModelService modelService;
    private static KatalonCommands instance;
    private ProjectEntity project;
    private KCommand addTestCaseStepCommand;
    private KCommand recordCommand;

    public static KatalonCommands getInstance() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (instance == null || instance.getProject() != currentProject) {
            instance = new KatalonCommands(currentProject);
        }
        instance.initialContextCommands();
        return instance;
    }

    private KatalonCommands(ProjectEntity project) {
        this.project = project;
        this.application = ApplicationSingleton.getInstance().getApplication();
        this.modelService = ModelServiceSingleton.getInstance().getModelService();
        this.rootCommand = KCommand.create(KATALON_COMMAND);
        this.initialGlobalCommands();
        this.initialOnlineHelpCommands();
        this.initialProjectCommands();
    }

    private void initialGlobalCommands() {
        this.rootCommand.addChild(KCommand.create(KATALON_HELP).setEventName("KATALON/HELP"));
        this.rootCommand.addChild(KCommand.create(KATALON_QUICK_GUIDE).setEventName("KATALON/QUICK_GUIDE"));
        this.rootCommand.addChild(KCommand.create(KATALON_WEBSITE).setEventName("KATALON/OPEN_URL").setEventData(KATALON_WEBSITE_URL));
        this.rootCommand.addChild(KCommand.create(KATALON_DOCUMENT).setEventName("KATALON/OPEN_URL").setEventData(KATALON_DOCUMENT_URL));
        this.rootCommand.addChild(KCommand.create(KATALON_QUESTIONS_AND_ANSWERS).setEventName("KATALON/OPEN_URL").setEventData(KATALON_QA_URL));
        this.rootCommand.addChild(KCommand.create(KATALON_PREFERENCES).setEventName("KATALON/PREFERENCES"));
    }

    private void initialOnlineHelpCommands() {
        KCommand moreHelpCommand = KCommand.create(MORE_HELP);
        try {
            KCommand onlineHelpCommand;
            String data = PlatformUI.getPreferenceStore().getString("general.onlineHelpContent");
            if (StringUtils.isNotBlank((String)data) && (onlineHelpCommand = (KCommand)JsonUtil.fromJson((String)data, KCommand.class)) != null) {
                moreHelpCommand = onlineHelpCommand;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        if (!moreHelpCommand.hasChildren()) {
            moreHelpCommand.setEventName("KATALON/LOAD_COMMANDS").setEventData("KATALON/UPDATE_HELP_CONTENTS");
        }
        this.rootCommand.addChild(moreHelpCommand);
    }

    private void initialProjectCommands() {
        if (this.project == null) {
            return;
        }
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_OPEN + TEST_CASE).setEventName("KATALON/LOAD_COMMANDS").setEventData("TESTCASE/OPEN"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_OPEN + TEST_SUITE).setEventName("KATALON/LOAD_COMMANDS").setEventData("TESTSUITE/OPEN"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_OPEN + TEST_OBJECT).setEventName("KATALON/LOAD_COMMANDS").setEventData("TESTOBJECT/OPEN"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_OPEN + TEST_DATA).setEventName("KATALON/LOAD_COMMANDS").setEventData("TESTDATA/OPEN"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_OPEN + CHECKPOINT).setEventName("KATALON/LOAD_COMMANDS").setEventData("CHECKPOINT/OPEN"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + TEST_CASE).setEventName("TESTCASE/NEW"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + TEST_SUITE).setEventName("TESTSUITE/NEW"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + TEST_SUITE_COLLECTION).setEventName("TEST_SUITE_COLLECTION/NEW"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + TEST_OBJECT).setEventName("TESTOBJECT/NEW"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + WEBSERVICE_OBJECT).setEventName("WSOBJECT/NEW"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + WEBSERVICE_OBJECTS_FROM_SWAGGER).setEventName("WSOBJECT/SWAGGER"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + WEBSERVICE_OBJECTS_FROM_WSDL).setEventName("WSOBJECT/WSDL"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + TEST_DATA).setEventName("TESTDATA/NEW"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + CHECKPOINT).setEventName("CHECKPOINT/NEW"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + KEYWORD).setEventName("KEYWORD/NEW"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_NEW + PACKAGE).setEventName("PACKAGE/NEW"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_EXPORT + FOLDER)).setEventName("FOLDER/EXPORT");
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_IMPORT + FOLDER)).setEventName("FOLDER/IMPORT");
        this.rootCommand.addChild(KCommand.create(PROJECT_SETTINGS).setEventName("PROJECT/SETTINGS"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_SPY_WEB_OBJECT).setEventName("OBJECT_SPY/WEB"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_SPY_MOBILE_OBJECT).setEventName("OBJECT_SPY/MOBILE"));
        this.rootCommand.addChild(KCommand.create(COMMAND_NAME_GENERATE_COMMAND).setEventName("KATALON/GENERATE_COMMAND"));
    }

    private void initialContextCommands() {
        if (this.addTestCaseStepCommand != null && this.recordCommand != null) {
            List<KCommand> childrenCommands = this.rootCommand.getChildren();
            childrenCommands.remove(this.addTestCaseStepCommand);
            childrenCommands.remove(this.recordCommand);
        }
        if (!this.isTestCasePartSelected()) {
            return;
        }
        Object testcaseStepCommands = this.application.getContext().get("TESTCASE/ADD_STEP");
        if (testcaseStepCommands == null) {
            return;
        }
        if (this.addTestCaseStepCommand == null) {
            this.addTestCaseStepCommand = KCommand.create(COMMAND_NAME_ADD_TEST_CASE_STEP).setChildren(new ArrayList<KCommand>((List)testcaseStepCommands));
        }
        if (this.recordCommand == null) {
            this.recordCommand = KCommand.create(COMMAND_NAME_RECORD).setEventName("KATALON/RECORD");
        }
        this.rootCommand.addChild(this.addTestCaseStepCommand);
        this.rootCommand.addChild(this.recordCommand);
    }

    private boolean isTestCasePartSelected() {
        return StringUtils.startsWith((String)this.getSelectedPartIdInComposerContentArea(), (String)"com.kms.katalon.composer.content.testcase");
    }

    public String getSelectedPartIdInComposerContentArea() {
        MPartStack composerStack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        if (composerStack == null || !composerStack.isVisible() || composerStack.getSelectedElement() == null) {
            return null;
        }
        return ((MPart)composerStack.getSelectedElement()).getElementId();
    }

    public static List<KCommand> createCommands(List<String> commandNames, String eventName) {
        if (commandNames == null || commandNames.isEmpty()) {
            return Collections.emptyList();
        }
        return commandNames.stream().filter(name -> StringUtils.isNotEmpty((String)name)).map(name -> KCommand.create(name).setEventName(eventName)).collect(Collectors.toList());
    }

    public KCommand getRootCommand() {
        return this.rootCommand;
    }

    private ProjectEntity getProject() {
        return this.project;
    }
}

