/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.control;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ExpandableComposite {
    private static final int DEFAULT_BODY_MARGIN = 24;
    private CLabel lblHeaderTitle;
    private Composite parent;
    private Composite bodyComposite;
    private Composite composite;
    boolean isExpanded;
    private String title;
    private int detailColumns;
    private int style;

    public ExpandableComposite(Composite parent, String title, int colums, boolean expandOnShow, int style) {
        this.parent = parent;
        this.title = title;
        this.detailColumns = colums;
        this.isExpanded = expandOnShow;
        this.style = style;
    }

    public Composite createControl() {
        this.composite = (Composite)ComponentBuilder.gridContainer((Composite)this.parent, (int)1, (int)this.style).fillHorizontal().build();
        this.lblHeaderTitle = new CLabel(this.composite, 0);
        this.lblHeaderTitle.setCursor(Display.getCurrent().getSystemCursor(21));
        this.lblHeaderTitle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.lblHeaderTitle.setText(this.title);
        this.lblHeaderTitle.setFont(JFaceResources.getFontRegistry().getBold(""));
        this.bodyComposite = (Composite)ComponentBuilder.gridContainer((Composite)this.composite, (int)this.detailColumns, (int)0).fillHorizontal().build();
        this.hookControlSelectListerners();
        this.collapse();
        return this.bodyComposite;
    }

    private void redrawHeaderTitleIndicator() {
        this.lblHeaderTitle.getParent().setRedraw(false);
        this.lblHeaderTitle.setImage(this.isExpanded ? ImageConstants.IMG_16_ARROW_DOWN : ImageConstants.IMG_16_ARROW);
        this.lblHeaderTitle.getParent().setRedraw(true);
    }

    private void hookControlSelectListerners() {
        this.lblHeaderTitle.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ExpandableComposite.this.expandCollapseBody();
            }
        });
    }

    protected void expandCollapseBody() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ExpandableComposite.this.isExpanded = !ExpandableComposite.this.isExpanded;
                ExpandableComposite.this.bodyComposite.setVisible(ExpandableComposite.this.isExpanded);
                GridData gdBodyComposite = (GridData)ExpandableComposite.this.bodyComposite.getLayoutData();
                gdBodyComposite.exclude = !ExpandableComposite.this.isExpanded;
                ExpandableComposite.this.composite.layout(true, true);
                ExpandableComposite.this.composite.getParent().layout();
                ExpandableComposite.this.redrawHeaderTitleIndicator();
            }
        });
    }

    public void expand() {
        this.isExpanded = false;
        this.expandCollapseBody();
    }

    public void collapse() {
        this.isExpanded = true;
        this.expandCollapseBody();
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }
}

