/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.impl.util.RichTextUtil;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ComponentInstallerDialog
extends ProgressMonitorDialogWithThread {
    private static String DEFAULT_TASKNAME = JFaceResources.getString((String)"ProgressMonitorDialog.message");
    private static String DEFAULT_DIALOG_TITLE = "Component Installer";
    private static String DEFAULT_END_MESSAGE = "The installation has been finished!";
    private static int BAR_DLUS = 5;
    private String endMessage = DEFAULT_END_MESSAGE;
    private boolean isSucceeded = true;
    private boolean isWarning = false;
    private Color WARNING_COLOR = ColorUtil.getWarningForegroudColor();
    private Color SUCCESS_COLOR = ColorUtil.getTextSuccessfulColor();
    private Color FAIL_COLOR = ColorUtil.getTextErrorColor();
    private StyledText txtDetails;
    private Label lblSubtask;
    private String dialogTitle = DEFAULT_DIALOG_TITLE;
    private Button btnFinish;
    private Label lblEndMessage;
    private String troubleshootBtnLink;
    private Button btnTroubleshoot;
    private Composite btnBarComposite;

    public ComponentInstallerDialog(Shell parentShell) {
        super(parentShell);
    }

    public ComponentInstallerDialog(Shell parentShell, String troubleshootBtnLink) {
        super(parentShell);
        this.troubleshootBtnLink = troubleshootBtnLink;
    }

    @Override
    protected void cancelPressed() {
        super.cancelPressed();
        this.decrementNestingDepth();
        this.getProgressMonitor().done();
        this.close();
    }

    protected void configureShell(Shell shell) {
        shell.setText(this.getDialogTitle());
        shell.setCursor(new Cursor((Device)shell.getDisplay(), 0));
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(DEFAULT_TASKNAME, true);
        this.createMessageArea(parent);
        this.createDetailsLog(parent);
        this.createProgressIndicator(parent);
        this.createSubTaskLabel(parent);
        this.createInstallationStatusLabel(parent);
        this.taskLabel = this.messageLabel;
        return parent;
    }

    protected Control createMessageArea(Composite parent) {
        Control messageArea = super.createMessageArea(parent);
        FontDescriptor bigDescriptor = FontDescriptor.createFrom((Font)this.messageLabel.getFont()).setHeight(16);
        Font bigFont = bigDescriptor.createFont((Device)this.messageLabel.getDisplay());
        this.messageLabel.setFont(bigFont);
        return messageArea;
    }

    private void createDetailsLog(Composite parent) {
        this.txtDetails = new StyledText(parent, 2632);
        GridData gdText = new GridData(4, 4, true, true);
        gdText.heightHint = 200;
        gdText.horizontalSpan = 2;
        this.txtDetails.setLayoutData((Object)gdText);
        this.txtDetails.setBackground(ColorUtil.getCompositeBackgroundColor());
        this.txtDetails.setForeground(ColorUtil.getDefaultTextColor());
    }

    private void createProgressIndicator(Composite parent) {
        this.lblSubtask = new Label(parent, 0);
        GridData gdSubtask = new GridData(4, 4, true, false);
        gdSubtask.horizontalSpan = 2;
        this.lblSubtask.setLayoutData((Object)gdSubtask);
        this.progressIndicator = new ProgressIndicator(parent);
        GridData gdProgress = new GridData(4, 128, true, false);
        gdProgress.heightHint = this.convertVerticalDLUsToPixels(BAR_DLUS);
        gdProgress.horizontalSpan = 2;
        this.progressIndicator.setLayoutData((Object)gdProgress);
    }

    private void createSubTaskLabel(Composite parent) {
        this.subTaskLabel = new Label(parent, 16448);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.subTaskLabel.setLayoutData((Object)gd);
        this.subTaskLabel.setFont(parent.getFont());
    }

    private void createInstallationStatusLabel(Composite parent) {
        this.lblEndMessage = new Label(parent, 16448);
        GridData gdStatus = new GridData(768);
        gdStatus.horizontalSpan = 2;
        this.lblEndMessage.setLayoutData((Object)gdStatus);
        this.lblEndMessage.setFont(parent.getFont());
        if (this.isWarning) {
            this.lblEndMessage.setForeground(this.WARNING_COLOR);
        } else if (this.isSucceeded) {
            this.lblEndMessage.setForeground(this.SUCCESS_COLOR);
        } else {
            this.lblEndMessage.setForeground(this.FAIL_COLOR);
        }
    }

    private void setMessage(String messageString, boolean force) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        if (force || this.messageLabel.isVisible()) {
            this.messageLabel.setToolTipText(this.message);
            this.messageLabel.setText(ComponentInstallerDialog.shortenText((String)this.message, (Control)this.messageLabel));
        }
    }

    public void setDialogTitle(String title) {
        this.dialogTitle = title;
        if (this.getShell() != null) {
            this.getShell().setText(title);
        }
    }

    private String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setDetails(String text) {
        this.txtDetails.setText(text);
    }

    public void appendInfo(String text) {
        if (this.txtDetails.isDisposed()) {
            return;
        }
        this.txtDetails.append(text);
        this.txtDetails.setTopIndex(this.txtDetails.getLineCount() - 1);
    }

    public void appendError(String text) {
        if (this.txtDetails.isDisposed()) {
            return;
        }
        RichTextUtil.appendErrorText(this.txtDetails, text);
        this.txtDetails.setTopIndex(this.txtDetails.getLineCount() - 1);
    }

    public void appendWarning(String text) {
        if (this.txtDetails.isDisposed()) {
            return;
        }
        RichTextUtil.appendWarningText(this.txtDetails, text);
        this.txtDetails.setTopIndex(this.txtDetails.getLineCount() - 1);
    }

    public void appendSuccess(String text) {
        if (this.txtDetails.isDisposed()) {
            return;
        }
        RichTextUtil.appendSuccessText(this.txtDetails, text);
        this.txtDetails.setTopIndex(this.txtDetails.getLineCount() - 1);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnBarComposite = parent;
        super.createButtonsForButtonBar(this.btnBarComposite);
        this.createFinishButton(this.btnBarComposite, false);
    }

    private void createFinishButton(Composite parent, boolean enabled) {
        this.btnFinish = this.createButton(parent, 16, IDialogConstants.FINISH_LABEL, true);
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)this.btnFinish.getDisplay(), 0);
        }
        this.btnFinish.setCursor(this.arrowCursor);
        this.btnFinish.setEnabled(enabled);
        this.btnFinish.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ComponentInstallerDialog.this.close();
            }
        });
    }

    private void createTroubleshootButton(Composite parent) {
        this.btnTroubleshoot = this.createButton(parent, 17, "Troubleshoot", false);
        this.btnTroubleshoot.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ComponentUtil.triggerLink((String)ComponentInstallerDialog.this.troubleshootBtnLink);
            }
        });
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void finishedRun() {
        this.decrementNestingDepth();
        this.updateButtonStatesWhenFinished();
        if (this.lblEndMessage != null && !this.lblEndMessage.isDisposed()) {
            this.lblEndMessage.setText(this.getSuccessfulMessage());
            this.lblEndMessage.requestLayout();
        }
    }

    private void updateButtonStatesWhenFinished() {
        if (this.btnFinish == null || this.btnFinish.isDisposed()) {
            return;
        }
        this.setCancelable(false);
        this.btnFinish.setEnabled(true);
        if (!this.isSucceeded && StringUtils.isNotBlank((CharSequence)this.troubleshootBtnLink)) {
            Display.getDefault().asyncExec(() -> {
                Shell[] shells = Display.getCurrent().getShells();
                Shell currentShell = Arrays.stream(shells).filter(shell -> StringUtils.containsAny((CharSequence)shell.getText(), (CharSequence[])new CharSequence[]{"Install WebDriverAgent", "Install Dependencies"})).findFirst().get();
                this.createTroubleshootButton(this.btnBarComposite);
                this.btnBarComposite.layout(true, true);
                currentShell.layout(new Control[]{this.getButton(1), this.getButton(17), this.getButton(16)});
            });
        }
        this.getButton(16).forceFocus();
    }

    public String getSuccessfulMessage() {
        return this.endMessage;
    }

    public void setSuccessfulMessage(String successfulMessage) {
        if (this.lblEndMessage != null) {
            this.lblEndMessage.setForeground(this.SUCCESS_COLOR);
        }
        this.isSucceeded = true;
        this.endMessage = successfulMessage;
    }

    public String getFailureMessage() {
        return this.endMessage;
    }

    public void setFailureMessage(String failureMessage) {
        if (this.lblEndMessage != null) {
            this.lblEndMessage.setForeground(this.FAIL_COLOR);
        }
        this.isSucceeded = false;
        this.endMessage = failureMessage;
    }

    public void setWarningMessage(String warningMessage) {
        if (this.lblEndMessage != null) {
            this.lblEndMessage.setForeground(this.WARNING_COLOR);
        }
        this.isSucceeded = true;
        this.isWarning = true;
        this.endMessage = warningMessage;
    }
}

