/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class CustomProgressMonitorDialog
extends ProgressMonitorDialogWithThread {
    private static String DEFAULT_TASKNAME = JFaceResources.getString((String)"ProgressMonitorDialog.message");
    private boolean isDisplayIcon = true;
    private static int BAR_DLUS = 9;
    private Image image;

    public CustomProgressMonitorDialog(Shell parent) {
        super(parent);
    }

    private void setMessage(String messageString, boolean force) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        if (force || this.messageLabel.isVisible()) {
            this.messageLabel.setToolTipText(this.message);
            this.messageLabel.setText(CustomProgressMonitorDialog.shortenText((String)this.message, (Control)this.messageLabel));
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(DEFAULT_TASKNAME, false);
        this.createMessageArea(parent);
        this.taskLabel = this.messageLabel;
        this.createProgressIndicator(parent);
        this.createSubTaskLabel(parent);
        if (this.image != null) {
            this.imageLabel.setImage(this.image);
        }
        ComponentUtil.setVisible((Control)this.imageLabel, (boolean)this.isDisplayIcon);
        ComponentUtil.fontSize((Control)this.taskLabel, (int)12);
        ComponentUtil.setMarginLeft((Composite)parent, (int)20);
        ComponentUtil.setMarginRight((Composite)parent, (int)20);
        return parent;
    }

    public void setIsDisplayIcon(boolean displayIcon) {
        this.isDisplayIcon = displayIcon;
    }

    public void setImage(Image img) {
        this.image = img;
    }

    private void createProgressIndicator(Composite parent) {
        this.progressIndicator = new ProgressIndicator(parent);
        GridData gdProgress = new GridData(4, 128, true, false);
        gdProgress.heightHint = this.convertVerticalDLUsToPixels(BAR_DLUS);
        gdProgress.horizontalSpan = 2;
        this.progressIndicator.setLayoutData((Object)gdProgress);
    }

    private void createSubTaskLabel(Composite parent) {
        this.subTaskLabel = new Label(parent, 16448);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.subTaskLabel.setLayoutData((Object)gd);
        this.subTaskLabel.setFont(parent.getFont());
        ComponentUtil.setColor((Control)this.subTaskLabel, (Color)ColorUtil.getColor((String)"#666666"));
    }
}

