/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.editors;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.editors.CustomTableEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;

public abstract class CustomColumViewerEditor
extends ColumnViewerEditor {
    private TableEditor tableEditor;
    private int feature;
    public static final int TABBING_CYCLE_IN_TABLE = 128;

    protected CustomColumViewerEditor(CTableViewer viewer, ColumnViewerEditorActivationStrategy editorActivationStrategy, int feature) {
        super((ColumnViewer)viewer, editorActivationStrategy, feature);
        viewer.setColumnViewerEditor(this);
        this.tableEditor = this.getTableEditor(viewer);
        this.feature = feature;
    }

    protected TableEditor getTableEditor(CTableViewer viewer) {
        return new CustomTableEditor(viewer);
    }

    protected void setEditor(Control w, Item item, int columnNumber) {
        this.tableEditor.setEditor(w, (TableItem)item, columnNumber);
    }

    protected void setLayoutData(CellEditor.LayoutData layoutData) {
        this.tableEditor.grabHorizontal = layoutData.grabHorizontal;
        this.tableEditor.horizontalAlignment = layoutData.horizontalAlignment;
        this.tableEditor.minimumWidth = layoutData.minimumWidth;
        this.tableEditor.verticalAlignment = layoutData.verticalAlignment;
        if (layoutData.minimumHeight != -1) {
            this.tableEditor.minimumHeight = layoutData.minimumHeight;
        }
    }

    protected void updateFocusCell(ViewerCell focusCell, ColumnViewerEditorActivationEvent event) {
    }

    protected abstract boolean isLastEditableCell(ViewerCell var1);

    protected Object firstEditableElement() {
        return this.getViewer().getElementAt(0);
    }

    protected int firstEditableColumnIndex() {
        return 0;
    }

    protected void processTraverseEvent(int columnIndex, ViewerRow row, TraverseEvent event) {
        if (this.isTabbingCycleInTableActive(event) && this.isLastEditableCell(row.getCell(columnIndex))) {
            Object firstEditableElement = this.firstEditableElement();
            if (firstEditableElement != null) {
                this.getViewer().editElement(firstEditableElement, this.firstEditableColumnIndex());
            }
            return;
        }
        super.processTraverseEvent(columnIndex, row, event);
    }

    private boolean isTabbingCycleInTableActive(TraverseEvent event) {
        return event.detail == 16 && (this.feature & 0x80) == 128;
    }

    protected TableViewer getViewer() {
        return (TableViewer)super.getViewer();
    }
}

